/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.junit;

import jakarta.persistence.EntityManagerFactory;
import java.util.Optional;
import org.hibernate.testing.orm.junit.AbstractEntityManagerFactoryScope;
import org.hibernate.testing.orm.junit.EntityManagerFactoryProducer;
import org.hibernate.testing.orm.junit.EntityManagerFactoryScope;
import org.hibernate.testing.orm.junit.EntityManagerFactoryScopeContainer;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;

public class EntityManagerFactoryScopeExtension
implements TestInstancePostProcessor,
AfterAllCallback,
TestExecutionExceptionHandler {
    private static final Logger log = Logger.getLogger(EntityManagerFactoryScopeExtension.class);
    public static final Object ENTITYMANAGER_FACTORY_KEY = "ENTITYMANAGER_FACTORY";

    public static ExtensionContext.Namespace namespace(Object testInstance) {
        return ExtensionContext.Namespace.create((Object[])new Object[]{EntityManagerFactoryScopeExtension.class.getName(), testInstance});
    }

    public static Optional<EntityManagerFactoryScope> findEntityManagerFactoryScope(ExtensionContext context) {
        Optional<Object> entityManagerFactoryScope = Optional.ofNullable(context.getStore(EntityManagerFactoryScopeExtension.namespace(context.getRequiredTestInstance())).get(ENTITYMANAGER_FACTORY_KEY));
        return entityManagerFactoryScope;
    }

    public EntityManagerFactoryScopeExtension() {
        log.trace((Object)"EntityManagerFactoryScopeExtension#<init>");
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) {
        log.trace((Object)"EntityManagerFactoryScopeExtension#postProcessTestInstance");
        if (EntityManagerFactoryScopeContainer.class.isInstance(testInstance)) {
            EntityManagerFactoryScopeContainer scopeContainer = (EntityManagerFactoryScopeContainer)EntityManagerFactoryScopeContainer.class.cast(testInstance);
            EntityManagerFactoryScopeImpl scope = new EntityManagerFactoryScopeImpl(scopeContainer.getEntityManagerFactoryProducer());
            context.getStore(EntityManagerFactoryScopeExtension.namespace(testInstance)).put(ENTITYMANAGER_FACTORY_KEY, (Object)scope);
            scopeContainer.injectEntityManagerFactoryScope(scope);
        }
    }

    public void afterAll(ExtensionContext context) {
        EntityManagerFactoryScope scope = (EntityManagerFactoryScope)context.getStore(EntityManagerFactoryScopeExtension.namespace(context.getRequiredTestInstance())).remove(ENTITYMANAGER_FACTORY_KEY);
        if (scope != null) {
            scope.releaseEntityManagerFactory();
        }
    }

    public void handleTestExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        Optional<EntityManagerFactoryScope> scopeOptional = EntityManagerFactoryScopeExtension.findEntityManagerFactoryScope(context);
        if (!scopeOptional.isPresent()) {
            log.debug((Object)"Could not locate EntityManagerFactoryScope on exception");
        } else {
            scopeOptional.get().releaseEntityManagerFactory();
        }
        throw throwable;
    }

    private static class EntityManagerFactoryScopeImpl
    extends AbstractEntityManagerFactoryScope {
        private final EntityManagerFactoryProducer producer;

        public EntityManagerFactoryScopeImpl(EntityManagerFactoryProducer producer) {
            log.trace((Object)"EntityManagerFactoryScope#<init>");
            this.producer = producer;
        }

        @Override
        protected EntityManagerFactory createEntityManagerFactory() {
            return this.producer.produceEntityManagerFactory();
        }
    }
}

