/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.transaction;

import jakarta.persistence.EntityManager;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.SharedSessionContract;
import org.hibernate.StatelessSession;
import org.hibernate.Transaction;
import org.hibernate.engine.spi.SessionImplementor;
import org.jboss.logging.Logger;

public abstract class TransactionUtil {
    private static final Logger log = Logger.getLogger(TransactionUtil.class);

    public static void inTransaction(SessionImplementor session, Consumer<SessionImplementor> action) {
        TransactionUtil.wrapInTransaction((SharedSessionContract)session, session, action);
    }

    public static void inTransaction(EntityManager entityManager, Consumer<EntityManager> action) {
        TransactionUtil.wrapInTransaction((SharedSessionContract)entityManager, entityManager, action);
    }

    public static void inTransaction(StatelessSession session, Consumer<StatelessSession> action) {
        TransactionUtil.wrapInTransaction((SharedSessionContract)session, session, action);
    }

    public static <R> R fromTransaction(SessionImplementor session, Function<SessionImplementor, R> action) {
        return TransactionUtil.wrapInTransaction((SharedSessionContract)session, session, action);
    }

    public static <R> R fromTransaction(EntityManager entityManager, Function<EntityManager, R> action) {
        return TransactionUtil.wrapInTransaction((SharedSessionContract)entityManager, entityManager, action);
    }

    private static <T> void wrapInTransaction(SharedSessionContract session, T actionInput, Consumer<T> action) {
        Transaction txn = session.beginTransaction();
        log.trace((Object)"Started transaction");
        try {
            log.trace((Object)"Calling action in txn");
            action.accept(actionInput);
            log.trace((Object)"Called action - in txn");
            if (!txn.getRollbackOnly()) {
                log.trace((Object)"Committing transaction");
                txn.commit();
                log.trace((Object)"Committed transaction");
            } else {
                try {
                    log.trace((Object)"Rollback transaction marked for rollback only");
                    txn.rollback();
                }
                catch (Exception e) {
                    log.error((Object)"Rollback failure", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            log.tracef("Error calling action: %s (%s) - rolling back", (Object)e.getClass().getName(), (Object)e.getMessage());
            try {
                txn.rollback();
            }
            catch (Exception ignore) {
                log.trace((Object)"Was unable to roll back transaction");
            }
            throw e;
        }
        catch (AssertionError t) {
            try {
                txn.rollback();
            }
            catch (Exception ignore) {
                log.trace((Object)"Was unable to roll back transaction");
            }
            throw t;
        }
    }

    private static <T, R> R wrapInTransaction(SharedSessionContract session, T actionInput, Function<T, R> action) {
        log.trace((Object)"Started transaction");
        Transaction txn = session.beginTransaction();
        try {
            log.trace((Object)"Calling action in txn");
            R result = action.apply(actionInput);
            log.trace((Object)"Called action - in txn");
            log.trace((Object)"Committing transaction");
            txn.commit();
            log.trace((Object)"Committed transaction");
            return result;
        }
        catch (Exception e) {
            log.tracef("Error calling action: %s (%s) - rolling back", (Object)e.getClass().getName(), (Object)e.getMessage());
            try {
                txn.rollback();
            }
            catch (Exception ignore) {
                log.trace((Object)"Was unable to roll back transaction");
            }
            throw e;
        }
        catch (AssertionError t) {
            try {
                txn.rollback();
            }
            catch (Exception ignore) {
                log.trace((Object)"Was unable to roll back transaction");
            }
            throw t;
        }
    }
}

