/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.search.mapper.mapping.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hibernate.search.engine.backend.common.spi.EntityReferenceFactory;
import org.hibernate.search.engine.backend.mapping.spi.BackendMappingContext;
import org.hibernate.search.engine.common.spi.SearchIntegration;
import org.hibernate.search.engine.environment.thread.spi.ThreadPoolProvider;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.mapper.pojo.loading.spi.PojoSelectionEntityLoader;
import org.hibernate.search.mapper.pojo.mapping.spi.AbstractPojoMappingImplementor;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoMappingDelegate;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexerAgent;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexerAgentCreateContext;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.scope.spi.PojoScopeDelegate;
import org.hibernate.search.mapper.pojo.scope.spi.PojoScopeMappingContext;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.infinispan.search.mapper.common.EntityReference;
import org.infinispan.search.mapper.common.impl.EntityReferenceImpl;
import org.infinispan.search.mapper.log.impl.Log;
import org.infinispan.search.mapper.mapping.EntityConverter;
import org.infinispan.search.mapper.mapping.SearchIndexedEntity;
import org.infinispan.search.mapper.mapping.SearchMapping;
import org.infinispan.search.mapper.mapping.impl.InfinispanTypeContextContainer;
import org.infinispan.search.mapper.mapping.metamodel.IndexMetamodel;
import org.infinispan.search.mapper.scope.SearchScope;
import org.infinispan.search.mapper.scope.impl.SearchScopeImpl;
import org.infinispan.search.mapper.session.SearchSession;
import org.infinispan.search.mapper.session.impl.InfinispanIndexedTypeContext;
import org.infinispan.search.mapper.session.impl.InfinispanSearchSession;
import org.infinispan.search.mapper.session.impl.InfinispanSearchSessionMappingContext;
import org.infinispan.search.mapper.work.SearchIndexer;
import org.infinispan.search.mapper.work.impl.SearchIndexerImpl;
import org.infinispan.util.concurrent.BlockingManager;
import org.infinispan.util.concurrent.NonBlockingManager;

public class InfinispanMapping
extends AbstractPojoMappingImplementor<SearchMapping>
implements SearchMapping,
InfinispanSearchSessionMappingContext,
EntityReferenceFactory<EntityReference> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final InfinispanTypeContextContainer typeContextContainer;
    private final PojoSelectionEntityLoader<?> entityLoader;
    private final EntityConverter entityConverter;
    private final SearchSession mappingSession;
    private final SearchIndexer searchIndexer;
    private final Set<String> allIndexedEntityNames;
    private final Set<Class<?>> allIndexedEntityJavaClasses;
    private SearchIntegration integration;
    private boolean close = false;

    InfinispanMapping(PojoMappingDelegate mappingDelegate, InfinispanTypeContextContainer typeContextContainer, PojoSelectionEntityLoader<?> entityLoader, EntityConverter entityConverter, BlockingManager blockingManager, NonBlockingManager nonBlockingManager) {
        super(mappingDelegate);
        this.typeContextContainer = typeContextContainer;
        this.entityLoader = entityLoader;
        this.entityConverter = entityConverter;
        this.mappingSession = new InfinispanSearchSession(this, entityLoader, typeContextContainer);
        this.searchIndexer = new SearchIndexerImpl(this.mappingSession.createIndexer(), entityConverter, typeContextContainer, blockingManager, nonBlockingManager);
        this.allIndexedEntityNames = typeContextContainer.allIndexed().stream().map(SearchIndexedEntity::name).collect(Collectors.toSet());
        this.allIndexedEntityJavaClasses = typeContextContainer.allIndexed().stream().map(SearchIndexedEntity::javaClass).collect(Collectors.toSet());
    }

    @Override
    public void close() {
        try (Closer closer = new Closer();){
            closer.push(SearchIntegration::close, (Object)this.integration);
            closer.push(SearchIndexer::close, (Object)this.searchIndexer);
            this.close = true;
        }
    }

    @Override
    public boolean isClose() {
        return this.close;
    }

    @Override
    public <E> SearchScope<E> scope(Collection<? extends Class<? extends E>> targetedTypes) {
        return this.createScope(targetedTypes);
    }

    @Override
    public Optional<SearchScope<?>> findScopeAll() {
        return Optional.of(this.doCreateScope(this.typeContextContainer.allTypeIdentifiers()));
    }

    @Override
    public SearchScope<?> scopeAll() {
        return this.doCreateScope(this.typeContextContainer.allTypeIdentifiers());
    }

    @Override
    public SearchSession getMappingSession() {
        return this.mappingSession;
    }

    @Override
    public SearchIndexer getSearchIndexer() {
        return this.searchIndexer;
    }

    @Override
    public SearchIndexedEntity indexedEntity(Class<?> entityType) {
        return this.typeContextContainer.indexedForExactType(entityType);
    }

    @Override
    public SearchIndexedEntity indexedEntity(String entityName) {
        return this.typeContextContainer.indexedForEntityName(entityName);
    }

    @Override
    public Collection<? extends SearchIndexedEntity> allIndexedEntities() {
        return this.typeContextContainer.allIndexed();
    }

    @Override
    public Set<String> allIndexedEntityNames() {
        return this.allIndexedEntityNames;
    }

    @Override
    public Set<Class<?>> allIndexedEntityJavaClasses() {
        return this.allIndexedEntityJavaClasses;
    }

    @Override
    public Class<?> toConvertedEntityJavaClass(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> c = value.getClass();
        if (this.entityConverter != null && c.equals(this.entityConverter.targetType())) {
            return this.entityConverter.convertedTypeIdentifier().javaClass();
        }
        return c;
    }

    @Override
    public Map<String, IndexMetamodel> metamodel() {
        return this.allIndexedEntities().stream().map(indexedEntity -> new IndexMetamodel((SearchIndexedEntity)indexedEntity)).collect(Collectors.toMap(IndexMetamodel::getEntityName, Function.identity()));
    }

    @Override
    public FailureHandler getFailureHandler() {
        return this.delegate().failureHandler();
    }

    @Override
    public <E> SearchScopeImpl<E> createScope(Collection<? extends Class<? extends E>> classes) {
        Class<?> converterTargetType = this.entityConverter == null ? null : this.entityConverter.targetType();
        ArrayList<PojoRawTypeIdentifier<Object>> typeIdentifiers = new ArrayList<PojoRawTypeIdentifier<Object>>(classes.size());
        for (Class<E> clazz : classes) {
            if (clazz.equals(converterTargetType)) {
                typeIdentifiers.add(this.entityConverter.convertedTypeIdentifier());
                continue;
            }
            typeIdentifiers.add(PojoRawTypeIdentifier.of(clazz));
        }
        return this.doCreateScope(typeIdentifiers);
    }

    public <E> SearchScopeImpl<E> createScope(Class<E> expectedSuperType, Collection<String> entityNames) {
        ArrayList<PojoRawTypeIdentifier<PojoRawTypeIdentifier<E>>> typeIdentifiers = new ArrayList<PojoRawTypeIdentifier<PojoRawTypeIdentifier<E>>>(entityNames.size());
        for (String entityName : entityNames) {
            typeIdentifiers.add(this.entityTypeIdentifier(expectedSuperType, entityName));
        }
        return this.doCreateScope(typeIdentifiers);
    }

    public SearchMapping toConcreteType() {
        return this;
    }

    public EntityReferenceFactory<EntityReference> entityReferenceFactory() {
        return this;
    }

    public ThreadPoolProvider threadPoolProvider() {
        return this.delegate().threadPoolProvider();
    }

    public FailureHandler failureHandler() {
        return this.delegate().failureHandler();
    }

    public PojoMassIndexerAgent createMassIndexerAgent(PojoMassIndexerAgentCreateContext context) {
        return PojoMassIndexerAgent.noOp();
    }

    public EntityReference createEntityReference(String typeName, Object identifier) {
        InfinispanIndexedTypeContext typeContext = this.typeContextContainer.indexedForEntityName(typeName);
        if (typeContext == null) {
            throw new AssertionFailure("Type name " + typeName + " refers to an unknown type");
        }
        return new EntityReferenceImpl(typeContext.typeIdentifier(), typeContext.name(), identifier);
    }

    public SearchIntegration getIntegration() {
        return this.integration;
    }

    public void setIntegration(SearchIntegration integration) {
        this.integration = integration;
    }

    private <E> SearchScopeImpl<E> doCreateScope(Collection<PojoRawTypeIdentifier<? extends E>> typeIdentifiers) {
        PojoScopeDelegate pojoScopeDelegate = this.delegate().createPojoScope((PojoScopeMappingContext)this, typeIdentifiers, typeIdentifier -> typeIdentifier);
        return new SearchScopeImpl((BackendMappingContext)this, pojoScopeDelegate, this.entityLoader);
    }

    private <T> PojoRawTypeIdentifier<? extends T> entityTypeIdentifier(Class<T> expectedSuperType, String entityName) {
        InfinispanIndexedTypeContext typeContext = this.typeContextContainer.indexedForEntityName(entityName);
        if (typeContext == null) {
            throw log.invalidEntityName(entityName);
        }
        PojoRawTypeIdentifier typeIdentifier = typeContext.typeIdentifier();
        Class actualJavaType = typeIdentifier.javaClass();
        if (!expectedSuperType.isAssignableFrom(actualJavaType)) {
            throw log.invalidEntitySuperType(entityName, expectedSuperType, actualJavaType);
        }
        PojoRawTypeIdentifier castedTypeIdentifier = typeIdentifier;
        return castedTypeIdentifier;
    }
}

