/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tasks;

import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.security.auth.Subject;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.Security;
import org.infinispan.security.mappers.IdentityRoleMapper;
import org.infinispan.tasks.DummyTaskEngine;
import org.infinispan.tasks.TaskContext;
import org.infinispan.tasks.TaskExecution;
import org.infinispan.tasks.TaskManager;
import org.infinispan.tasks.impl.TaskManagerImpl;
import org.infinispan.tasks.spi.TaskEngine;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tasks.SecurityTaskManagerTest")
public class SecurityTaskManagerTest
extends SingleCacheManagerTest {
    static final Subject ADMIN = TestingUtil.makeSubject((String[])new String[]{"admin", "admin"});
    static final Subject HACKER = TestingUtil.makeSubject((String[])new String[]{"hacker", "hacker"});
    private TaskManagerImpl taskManager;
    private DummyTaskEngine taskEngine;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        GlobalConfigurationBuilder global = new GlobalConfigurationBuilder();
        global.security().authorization().enable().principalRoleMapper((PrincipalRoleMapper)new IdentityRoleMapper()).role("admin").permission(AuthorizationPermission.ALL);
        ConfigurationBuilder config = new ConfigurationBuilder();
        config.security().authorization().enable().role("admin");
        return TestCacheManagerFactory.createCacheManager((GlobalConfigurationBuilder)global, (ConfigurationBuilder)config);
    }

    protected void setup() throws Exception {
        Security.doAs((Subject)ADMIN, (PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                SecurityTaskManagerTest.super.setup();
                SecurityTaskManagerTest.this.taskManager = (TaskManagerImpl)SecurityTaskManagerTest.this.cacheManager.getGlobalComponentRegistry().getComponent(TaskManager.class);
                SecurityTaskManagerTest.this.taskEngine = new DummyTaskEngine();
                SecurityTaskManagerTest.this.taskManager.registerTaskEngine((TaskEngine)SecurityTaskManagerTest.this.taskEngine);
                return null;
            }
        });
    }

    protected void teardown() {
        Security.doAs((Subject)ADMIN, (PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                SecurityTaskManagerTest.super.teardown();
                return null;
            }
        });
    }

    protected void clearContent() {
        Security.doAs((Subject)ADMIN, (PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                SecurityTaskManagerTest.this.cacheManager.getCache().clear();
                return null;
            }
        });
    }

    @Test(dataProvider="principalProvider")
    public void testTaskExecutionWithAuthorization(final String principal, Subject subject) throws Exception {
        Security.doAs((Subject)subject, (PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                CompletableFuture slowTask = SecurityTaskManagerTest.this.taskManager.runTask(DummyTaskEngine.DummyTaskTypes.SLOW_TASK.name(), new TaskContext()).toCompletableFuture();
                List currentTasks = SecurityTaskManagerTest.this.taskManager.getCurrentTasks();
                AssertJUnit.assertEquals((int)1, (int)currentTasks.size());
                TaskExecution currentTask = (TaskExecution)currentTasks.iterator().next();
                AssertJUnit.assertEquals((String)DummyTaskEngine.DummyTaskTypes.SLOW_TASK.name(), (String)currentTask.getName());
                AssertJUnit.assertEquals((String)principal, (String)((String)currentTask.getWho().get()));
                SecurityTaskManagerTest.this.taskEngine.getSlowTask().complete("slow");
                AssertJUnit.assertEquals((int)0, (int)SecurityTaskManagerTest.this.taskManager.getCurrentTasks().size());
                try {
                    AssertJUnit.assertEquals((Object)"slow", slowTask.get());
                }
                catch (InterruptedException | ExecutionException e) {
                    AssertJUnit.fail((String)"Exception thrown while getting the slowTask. ");
                }
                SecurityTaskManagerTest.this.taskEngine.setSlowTask(new CompletableFuture<String>());
                return null;
            }
        });
    }

    @DataProvider(name="principalProvider")
    private static Object[][] providePrincipals() {
        return new Object[][]{{"admin", ADMIN}, {"hacker", HACKER}};
    }
}

