/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.entity.entitycache;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ejb.NoSuchEntityException;
import org.jboss.as.ejb3.component.entity.EntityBeanComponent;
import org.jboss.as.ejb3.component.entity.EntityBeanComponentInstance;
import org.jboss.as.ejb3.component.entity.entitycache.ReadyEntityCache;

public class ReferenceCountingEntityCache
implements ReadyEntityCache {
    private final ConcurrentMap<Object, CacheEntry> cache = new ConcurrentHashMap<Object, CacheEntry>();
    private final EntityBeanComponent component;

    public ReferenceCountingEntityCache(EntityBeanComponent component) {
        this.component = component;
    }

    @Override
    public void create(EntityBeanComponentInstance instance) {
        if (this.cache.putIfAbsent(instance.getPrimaryKey(), new CacheEntry(instance)) != null) {
            throw new IllegalArgumentException("Instance for PK [" + instance.getPrimaryKey() + "] already registerd.");
        }
    }

    @Override
    public EntityBeanComponentInstance get(Object key) throws NoSuchEntityException {
        if (!this.cache.containsKey(key)) {
            EntityBeanComponentInstance instance = this.createInstance(key);
            this.create(instance);
        }
        return ((CacheEntry)this.cache.get(key)).instance;
    }

    @Override
    public void reference(EntityBeanComponentInstance instance) {
        CacheEntry cacheEntry = (CacheEntry)this.cache.get(instance.getPrimaryKey());
        if (cacheEntry == null) {
            throw new IllegalArgumentException("Instance [" + (Object)((Object)instance) + "] not found in cache");
        }
        cacheEntry.referenceCount.incrementAndGet();
    }

    @Override
    public void release(EntityBeanComponentInstance instance, boolean success) {
        if (instance.getPrimaryKey() == null) {
            return;
        }
        CacheEntry cacheEntry = (CacheEntry)this.cache.get(instance.getPrimaryKey());
        if (cacheEntry == null) {
            throw new IllegalArgumentException("Instance [" + (Object)((Object)instance) + "] not found in cache");
        }
        if (cacheEntry.referenceCount.decrementAndGet() == 0) {
            if (!success && instance.isRemoved()) {
                instance.setRemoved(false);
            }
            instance.passivate();
            this.component.getPool().release(instance);
            this.discard(instance);
        }
    }

    @Override
    public void discard(EntityBeanComponentInstance instance) {
        this.cache.remove(instance.getPrimaryKey());
        instance.discard();
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    private EntityBeanComponentInstance createInstance(Object pk) {
        EntityBeanComponentInstance instance = this.component.getPool().get();
        instance.associate(pk);
        return instance;
    }

    private class CacheEntry {
        private final AtomicInteger referenceCount = new AtomicInteger(0);
        private final EntityBeanComponentInstance instance;

        private CacheEntry(EntityBeanComponentInstance instance) {
            this.instance = instance;
        }
    }
}

