/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.messagedriven;

import java.util.Properties;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.ResourceAdapter;
import org.jboss.as.connector.ConnectorServices;
import org.jboss.as.ee.component.BasicComponent;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.EJBComponentCreateService;
import org.jboss.as.ejb3.component.messagedriven.DefaultResourceAdapterService;
import org.jboss.as.ejb3.component.messagedriven.MessageDrivenComponent;
import org.jboss.as.ejb3.component.messagedriven.MessageDrivenComponentDescription;
import org.jboss.as.ejb3.component.pool.PoolConfig;
import org.jboss.as.ejb3.deployment.ApplicationExceptions;
import org.jboss.as.ejb3.inflow.EndpointDeployer;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.value.InjectedValue;

public class MessageDrivenComponentCreateService
extends EJBComponentCreateService {
    private final Class<?> messageListenerInterface;
    private String resourceAdapterName;
    private final Properties activationProps;
    private final InjectedValue<PoolConfig> poolConfig = new InjectedValue();
    private final InjectedValue<DefaultResourceAdapterService> defaultRANameService = new InjectedValue();

    public MessageDrivenComponentCreateService(ComponentConfiguration componentConfiguration, ApplicationExceptions ejbJarConfiguration) {
        super(componentConfiguration, ejbJarConfiguration);
        MessageDrivenComponentDescription componentDescription = (MessageDrivenComponentDescription)componentConfiguration.getComponentDescription();
        this.resourceAdapterName = this.stripDotRarSuffix(componentDescription.getResourceAdapterName());
        this.messageListenerInterface = ((ViewConfiguration)componentConfiguration.getViews().get(0)).getViewClass();
        this.activationProps = componentDescription.getActivationProps();
    }

    protected BasicComponent createComponent() {
        if (this.resourceAdapterName == null) {
            this.resourceAdapterName = this.getDefaultResourceAdapterName();
        }
        ServiceName raServiceName = this.getResourceAdapterServiceName();
        ActivationSpec activationSpec = this.getEndpointDeployer().createActivationSpecs(this.resourceAdapterName, this.messageListenerInterface, this.activationProps, this.getDeploymentClassLoader());
        MessageDrivenComponent component = new MessageDrivenComponent(this, this.messageListenerInterface, activationSpec);
        ResourceAdapter resourceAdapter = (ResourceAdapter)this.getRequiredService(raServiceName, ResourceAdapter.class).getValue();
        component.setResourceAdapter(resourceAdapter);
        try {
            activationSpec.setResourceAdapter(resourceAdapter);
        }
        catch (ResourceException e) {
            throw new RuntimeException(e);
        }
        return component;
    }

    PoolConfig getPoolConfig() {
        return (PoolConfig)this.poolConfig.getOptionalValue();
    }

    public InjectedValue<PoolConfig> getPoolConfigInjector() {
        return this.poolConfig;
    }

    public InjectedValue<DefaultResourceAdapterService> getDefaultRANameServiceInjector() {
        return this.defaultRANameService;
    }

    String getDefaultResourceAdapterName() {
        DefaultResourceAdapterService defaultResourceAdapterService = (DefaultResourceAdapterService)this.defaultRANameService.getOptionalValue();
        if (defaultResourceAdapterService != null) {
            return this.stripDotRarSuffix(defaultResourceAdapterService.getDefaultResourceAdapterName());
        }
        return "hornetq-ra";
    }

    private ClassLoader getDeploymentClassLoader() {
        return this.getComponentClass().getClassLoader();
    }

    private EndpointDeployer getEndpointDeployer() {
        return this.getEJBUtilities();
    }

    private <S> ServiceController<S> getRequiredService(ServiceName serviceName, Class<S> expectedType) {
        return this.getServiceRegistry().getRequiredService(serviceName);
    }

    private ServiceRegistry getServiceRegistry() {
        return ((DeploymentUnit)this.getDeploymentUnitInjector().getValue()).getServiceRegistry();
    }

    ServiceName getResourceAdapterServiceName() {
        Set serviceNames = ConnectorServices.getResourceAdapterServiceNames((String)this.resourceAdapterName);
        if (serviceNames == null || serviceNames.isEmpty()) {
            throw EjbMessages.MESSAGES.failToFindResourceAdapter(this.resourceAdapterName);
        }
        return (ServiceName)serviceNames.iterator().next();
    }

    private String stripDotRarSuffix(String raName) {
        if (raName == null) {
            return null;
        }
        if (raName.endsWith(".rar")) {
            return raName.substring(0, raName.indexOf(".rar"));
        }
        return raName;
    }
}

