/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import javax.ejb.EJBException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.ScheduleExpression;
import javax.ejb.TimerConfig;
import javax.ejb.TimerHandle;
import javax.ejb.TimerService;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.component.singleton.SingletonComponent;
import org.jboss.as.ejb3.component.stateful.CurrentSynchronizationCallback;
import org.jboss.as.ejb3.context.CurrentInvocationContext;
import org.jboss.as.ejb3.timerservice.AutoTimer;
import org.jboss.as.ejb3.timerservice.CalendarTimer;
import org.jboss.as.ejb3.timerservice.TimerHandleImpl;
import org.jboss.as.ejb3.timerservice.TimerImpl;
import org.jboss.as.ejb3.timerservice.TimerState;
import org.jboss.as.ejb3.timerservice.persistence.CalendarTimerEntity;
import org.jboss.as.ejb3.timerservice.persistence.TimeoutMethod;
import org.jboss.as.ejb3.timerservice.persistence.TimerEntity;
import org.jboss.as.ejb3.timerservice.persistence.TimerPersistence;
import org.jboss.as.ejb3.timerservice.schedule.CalendarBasedTimeout;
import org.jboss.as.ejb3.timerservice.spi.ScheduleTimer;
import org.jboss.as.ejb3.timerservice.spi.TimedObjectInvoker;
import org.jboss.as.ejb3.timerservice.task.TimerTask;
import org.jboss.invocation.InterceptorContext;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class TimerServiceImpl
implements TimerService,
Service<TimerService> {
    private static final Set<TimerState> ineligibleTimerStates;
    private static final Logger logger;
    public static final ServiceName SERVICE_NAME;
    private final ServiceName serviceName;
    private final InjectedValue<EJBComponent> ejbComponentInjectedValue = new InjectedValue();
    private final InjectedValue<ExecutorService> executorServiceInjectedValue = new InjectedValue();
    private final InjectedValue<Timer> timerInjectedValue = new InjectedValue();
    private final Map<Method, List<AutoTimer>> autoTimers;
    private final InjectedValue<TimerPersistence> timerPersistence = new InjectedValue();
    private final Map<TimerHandle, TimerImpl> nonPersistentTimers = new ConcurrentHashMap<TimerHandle, TimerImpl>();
    private final Map<TimerHandle, TimerImpl> persistentWaitingOnTxCompletionTimers = new ConcurrentHashMap<TimerHandle, TimerImpl>();
    private final Map<TimerHandle, java.util.TimerTask> scheduledTimerFutures = new ConcurrentHashMap<TimerHandle, java.util.TimerTask>();
    private TransactionManager transactionManager;
    private volatile boolean started = false;

    public TimerServiceImpl(Map<Method, List<AutoTimer>> autoTimers, ServiceName serviceName) {
        this.autoTimers = autoTimers;
        this.serviceName = serviceName;
    }

    public synchronized void start(StartContext context) throws StartException {
        logger.debug((Object)("Starting timerservice for timedObjectId: " + this.getInvoker().getTimedObjectId()));
        EJBComponent component = (EJBComponent)((Object)this.ejbComponentInjectedValue.getValue());
        this.transactionManager = component.getTransactionManager();
        TimedObjectInvoker invoker = component.getTimedObjectInvoker();
        if (invoker == null) {
            throw EjbMessages.MESSAGES.invokerIsNull();
        }
        ArrayList<ScheduleTimer> timers = new ArrayList<ScheduleTimer>();
        for (Map.Entry<Method, List<AutoTimer>> entry : this.autoTimers.entrySet()) {
            for (AutoTimer timer : entry.getValue()) {
                timers.add(new ScheduleTimer(entry.getKey(), timer.getScheduleExpression(), timer.getTimerConfig()));
            }
        }
        this.restoreTimers(timers);
        this.started = true;
    }

    public synchronized void stop(StopContext context) {
        this.suspendTimers();
        this.started = false;
        this.transactionManager = null;
    }

    public synchronized TimerService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public javax.ejb.Timer createCalendarTimer(ScheduleExpression schedule) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.handleLifecycleCallback();
        return this.createCalendarTimer(schedule, null);
    }

    public javax.ejb.Timer createCalendarTimer(ScheduleExpression schedule, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.handleLifecycleCallback();
        Serializable info = timerConfig == null ? null : timerConfig.getInfo();
        boolean persistent = timerConfig == null || timerConfig.isPersistent();
        return this.createCalendarTimer(schedule, info, persistent, null);
    }

    public javax.ejb.Timer createIntervalTimer(Date initialExpiration, long intervalDuration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.handleLifecycleCallback();
        if (initialExpiration == null) {
            throw EjbMessages.MESSAGES.initialExpirationIsNullCreatingTimer();
        }
        if (initialExpiration.getTime() < 0L) {
            throw EjbMessages.MESSAGES.invalidInitialExpiration("initialExpiration.getTime()");
        }
        if (intervalDuration < 0L) {
            throw EjbMessages.MESSAGES.invalidInitialExpiration("intervalDuration");
        }
        return this.createTimer(initialExpiration, intervalDuration, timerConfig.getInfo(), timerConfig.isPersistent());
    }

    public javax.ejb.Timer createIntervalTimer(long initialDuration, long intervalDuration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.handleLifecycleCallback();
        if (initialDuration < 0L) {
            throw EjbMessages.MESSAGES.invalidInitialExpiration("intervalDuration");
        }
        if (intervalDuration < 0L) {
            throw EjbMessages.MESSAGES.invalidInitialExpiration("intervalDuration");
        }
        return this.createIntervalTimer(new Date(System.currentTimeMillis() + initialDuration), intervalDuration, timerConfig);
    }

    public javax.ejb.Timer createSingleActionTimer(Date expiration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.handleLifecycleCallback();
        if (expiration == null) {
            throw EjbMessages.MESSAGES.expirationIsNull();
        }
        if (expiration.getTime() < 0L) {
            throw EjbMessages.MESSAGES.invalidExpirationActionTimer();
        }
        return this.createTimer(expiration, 0L, timerConfig.getInfo(), timerConfig.isPersistent());
    }

    public javax.ejb.Timer createSingleActionTimer(long duration, TimerConfig timerConfig) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.handleLifecycleCallback();
        if (duration < 0L) {
            throw EjbMessages.MESSAGES.invalidDurationActionTimer();
        }
        return this.createTimer(new Date(System.currentTimeMillis() + duration), 0L, timerConfig.getInfo(), timerConfig.isPersistent());
    }

    public javax.ejb.Timer createTimer(long duration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.handleLifecycleCallback();
        if (duration < 0L) {
            throw EjbMessages.MESSAGES.invalidDurationTimer();
        }
        return this.createTimer(new Date(System.currentTimeMillis() + duration), 0L, info, true);
    }

    public javax.ejb.Timer createTimer(Date expiration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.handleLifecycleCallback();
        if (expiration == null) {
            throw EjbMessages.MESSAGES.expirationDateIsNull();
        }
        if (expiration.getTime() < 0L) {
            throw EjbMessages.MESSAGES.invalidExpirationTimer();
        }
        return this.createTimer(expiration, 0L, info, true);
    }

    public javax.ejb.Timer createTimer(long initialDuration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.handleLifecycleCallback();
        if (initialDuration < 0L) {
            throw EjbMessages.MESSAGES.invalidInitialDurationTimer();
        }
        if (intervalDuration < 0L) {
            throw EjbMessages.MESSAGES.invalidIntervalTimer();
        }
        return this.createTimer(new Date(System.currentTimeMillis() + initialDuration), intervalDuration, info, true);
    }

    public javax.ejb.Timer createTimer(Date initialExpiration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        this.handleLifecycleCallback();
        if (initialExpiration == null) {
            throw EjbMessages.MESSAGES.initialExpirationDateIsNull();
        }
        if (initialExpiration.getTime() < 0L) {
            throw EjbMessages.MESSAGES.invalidExpirationTimer();
        }
        if (intervalDuration < 0L) {
            throw EjbMessages.MESSAGES.invalidIntervalDurationTimer();
        }
        return this.createTimer(initialExpiration, intervalDuration, info, true);
    }

    public TimerImpl loadAutoTimer(ScheduleExpression schedule, Method timeoutMethod) {
        return this.createCalendarTimer(schedule, null, true, timeoutMethod);
    }

    public TimerImpl loadAutoTimer(ScheduleExpression schedule, TimerConfig timerConfig, Method timeoutMethod) {
        return this.createCalendarTimer(schedule, timerConfig.getInfo(), timerConfig.isPersistent(), timeoutMethod);
    }

    public Collection<javax.ejb.Timer> getTimers() throws IllegalStateException, EJBException {
        this.handleLifecycleCallback();
        HashSet<javax.ejb.Timer> activeTimers = new HashSet<javax.ejb.Timer>();
        for (TimerImpl timer : this.nonPersistentTimers.values()) {
            if (ineligibleTimerStates.contains((Object)timer.getState()) || !timer.isActive()) continue;
            activeTimers.add(timer);
        }
        for (TimerImpl timer : this.persistentWaitingOnTxCompletionTimers.values()) {
            if (ineligibleTimerStates.contains((Object)timer.getState()) || !timer.isActive()) continue;
            activeTimers.add(timer);
        }
        activeTimers.addAll(this.getActivePersistentTimers());
        return activeTimers;
    }

    private javax.ejb.Timer createTimer(Date initialExpiration, long intervalDuration, Serializable info, boolean persistent) {
        if (this.isLifecycleCallbackInvocation() && !this.isSingletonBeanInvocation()) {
            throw EjbMessages.MESSAGES.failToCreateTimerDoLifecycle();
        }
        if (initialExpiration == null) {
            throw EjbMessages.MESSAGES.initialExpirationIsNull();
        }
        if (intervalDuration < 0L) {
            throw EjbMessages.MESSAGES.invalidIntervalDuration();
        }
        UUID uuid = UUID.randomUUID();
        TimerImpl timer = new TimerImpl(uuid.toString(), this, initialExpiration, intervalDuration, info, persistent);
        if (persistent) {
            this.persistTimer(timer);
        }
        this.startTimer(timer);
        this.addTimer(timer);
        return timer;
    }

    private TimerImpl createCalendarTimer(ScheduleExpression schedule, Serializable info, boolean persistent, Method timeoutMethod) {
        if (this.isLifecycleCallbackInvocation() && !this.isSingletonBeanInvocation()) {
            throw EjbMessages.MESSAGES.failToCreateTimerDoLifecycle();
        }
        if (schedule == null) {
            throw EjbMessages.MESSAGES.scheduleIsNull();
        }
        CalendarBasedTimeout calendarTimeout = new CalendarBasedTimeout(schedule);
        UUID uuid = UUID.randomUUID();
        CalendarTimer timer = new CalendarTimer(uuid.toString(), this, calendarTimeout, info, persistent, timeoutMethod);
        if (persistent) {
            this.persistTimer(timer);
        }
        this.startTimer(timer);
        this.addTimer(timer);
        return timer;
    }

    protected void addTimer(TimerImpl timer) {
        if (!timer.persistent) {
            this.nonPersistentTimers.put(timer.getTimerHandle(), timer);
        } else {
            this.persistentWaitingOnTxCompletionTimers.put(timer.getTimerHandle(), timer);
        }
    }

    public TimedObjectInvoker getInvoker() {
        return ((EJBComponent)((Object)this.ejbComponentInjectedValue.getValue())).getTimedObjectInvoker();
    }

    public TimerImpl getTimer(TimerHandle handle) {
        TimerImpl timer = this.nonPersistentTimers.get(handle);
        if (timer != null) {
            return timer;
        }
        timer = this.persistentWaitingOnTxCompletionTimers.get(handle);
        if (timer != null) {
            return timer;
        }
        TimerHandleImpl timerHandle = (TimerHandleImpl)handle;
        return this.getPersistedTimer(timerHandle);
    }

    protected Transaction getTransaction() {
        try {
            return this.transactionManager.getTransaction();
        }
        catch (SystemException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    void removeTimer(TimerImpl timer) {
        if (!timer.persistent) {
            this.nonPersistentTimers.remove(timer.getTimerHandle());
        } else {
            this.persistentWaitingOnTxCompletionTimers.remove(timer.getTimerHandle());
            ((TimerPersistence)this.timerPersistence.getValue()).removeTimer(timer.getPersistentState());
        }
    }

    public void persistTimer(TimerImpl timer) {
        if (timer == null) {
            return;
        }
        if (!timer.persistent) {
            switch (timer.getState()) {
                case CANCELED: 
                case EXPIRED: {
                    this.nonPersistentTimers.remove(timer.handle);
                }
            }
        } else {
            TimerEntity timerEntity = timer.getPersistentState();
            try {
                this.persistentWaitingOnTxCompletionTimers.remove(timer.handle);
                if (this.timerPersistence == null) {
                    EjbLogger.ROOT_LOGGER.timerPersistenceNotEnable();
                    return;
                }
                if (timerEntity.getTimerState() == TimerState.EXPIRED || timerEntity.getTimerState() == TimerState.CANCELED) {
                    ((TimerPersistence)this.timerPersistence.getValue()).removeTimer(timerEntity);
                } else {
                    ((TimerPersistence)this.timerPersistence.getValue()).persistTimer(timerEntity);
                }
            }
            catch (Throwable t) {
                this.setRollbackOnly();
                throw new RuntimeException(t);
            }
        }
    }

    public void suspendTimers() {
        Collection<javax.ejb.Timer> timers = this.getTimers();
        for (javax.ejb.Timer timer : timers) {
            if (!(timer instanceof TimerImpl)) continue;
            ((TimerImpl)timer).suspend();
        }
    }

    public void restoreTimers(List<ScheduleTimer> autoTimers) {
        List<TimerImpl> restorableTimers = this.getActivePersistentTimers();
        LinkedList<ScheduleTimer> newAutoTimers = new LinkedList<ScheduleTimer>(autoTimers);
        EjbLogger.ROOT_LOGGER.debug("Found " + restorableTimers.size() + " active timers for timedObjectId: " + ((EJBComponent)((Object)this.ejbComponentInjectedValue.getValue())).getTimedObjectInvoker().getTimedObjectId());
        for (TimerImpl activeTimer : restorableTimers) {
            if (activeTimer.isAutoTimer()) {
                boolean found = false;
                CalendarTimerEntity entity = (CalendarTimerEntity)activeTimer.getPersistentState();
                ListIterator it = newAutoTimers.listIterator();
                while (it.hasNext()) {
                    ScheduleTimer timer = (ScheduleTimer)it.next();
                    String methodName = timer.getMethod().getName();
                    String[] params = new String[timer.getMethod().getParameterTypes().length];
                    for (int i = 0; i < timer.getMethod().getParameterTypes().length; ++i) {
                        params[i] = timer.getMethod().getParameterTypes()[i].getName();
                    }
                    if (!this.doesTimeoutMethodMatch(entity.getTimeoutMethod(), methodName, params) || !this.doesScheduleMatch(entity.getScheduleExpression(), timer.getScheduleExpression())) continue;
                    it.remove();
                    found = true;
                    break;
                }
                if (found) {
                    this.startTimer(activeTimer);
                    EjbLogger.ROOT_LOGGER.debug("Started timer: " + activeTimer);
                    this.persistTimer(activeTimer);
                } else {
                    this.removeTimer(activeTimer);
                }
            }
            this.startTimer(activeTimer);
            EjbLogger.ROOT_LOGGER.debug("Started timer: " + activeTimer);
        }
        for (ScheduleTimer timer : newAutoTimers) {
            this.loadAutoTimer(timer.getScheduleExpression(), timer.getTimerConfig(), timer.getMethod());
        }
    }

    protected void startTimer(TimerImpl timer) {
        this.registerTimerWithTx(timer);
        this.startInTx(timer);
    }

    protected void registerTimerWithTx(TimerImpl timer) {
        Transaction tx = this.getTransaction();
        if (tx != null) {
            try {
                int status = tx.getStatus();
                if (status == 1 || status == 4 || status == 9 || status == 6 || status == 5 || status == 3 || this.isBeforeCompletion()) {
                    return;
                }
                tx.registerSynchronization((Synchronization)new TimerCreationTransactionSynchronization(timer));
            }
            catch (RollbackException e) {
                throw new EJBException((Exception)((Object)e));
            }
            catch (SystemException e) {
                throw new EJBException((Exception)((Object)e));
            }
        }
    }

    private boolean isBeforeCompletion() {
        CurrentSynchronizationCallback.CallbackType type = CurrentSynchronizationCallback.get();
        if (type != null) {
            return type == CurrentSynchronizationCallback.CallbackType.BEFORE_COMPLETION;
        }
        return false;
    }

    protected void startInTx(TimerImpl timer) {
        timer.setTimerState(TimerState.ACTIVE);
        this.persistTimer(timer);
        if (this.getTransaction() == null) {
            timer.scheduleTimeout();
        }
    }

    protected boolean isLifecycleCallbackInvocation() {
        InterceptorContext currentInvocationContext = CurrentInvocationContext.get();
        if (currentInvocationContext == null) {
            return false;
        }
        Method invokedMethod = currentInvocationContext.getMethod();
        return invokedMethod == null;
    }

    protected void scheduleTimeout(TimerImpl timer) {
        long intervalDuration;
        Date nextExpiration = timer.getNextExpiration();
        if (nextExpiration == null) {
            EjbLogger.ROOT_LOGGER.nextExpirationIsNull(timer);
            return;
        }
        TimerTask<?> timerTask = timer.getTimerTask();
        long delay = nextExpiration.getTime() - System.currentTimeMillis();
        if (delay < 0L) {
            delay = 0L;
        }
        if ((intervalDuration = timer.getInterval()) > 0L) {
            EjbLogger.ROOT_LOGGER.debug("Scheduling timer " + timer + " at fixed rate, starting at " + delay + " milli seconds from now with repeated interval=" + intervalDuration);
            Task task = new Task(timerTask);
            ((Timer)this.timerInjectedValue.getValue()).scheduleAtFixedRate((java.util.TimerTask)task, delay, intervalDuration);
            this.scheduledTimerFutures.put(timer.getTimerHandle(), task);
        } else {
            EjbLogger.ROOT_LOGGER.debug("Scheduling a single action timer " + timer + " starting at " + delay + " milli seconds from now");
            ((Timer)this.timerInjectedValue.getValue()).schedule((java.util.TimerTask)new Task(timerTask), delay);
            Task task = new Task(timerTask);
            this.scheduledTimerFutures.put(timer.getTimerHandle(), task);
        }
    }

    protected void cancelTimeout(TimerImpl timer) {
        TimerHandle handle = timer.getTimerHandle();
        java.util.TimerTask timerTask = this.scheduledTimerFutures.get(handle);
        if (timerTask != null) {
            timerTask.cancel();
        }
    }

    private boolean isSingletonBeanInvocation() {
        return this.ejbComponentInjectedValue.getValue() instanceof SingletonComponent;
    }

    private TimerImpl getPersistedTimer(TimerHandleImpl timerHandle) {
        String id = timerHandle.getId();
        String timedObjectId = timerHandle.getTimedObjectId();
        if (this.timerPersistence == null) {
            return null;
        }
        TimerEntity timerEntity = ((TimerPersistence)this.timerPersistence.getValue()).loadTimer(id, timedObjectId);
        if (timerEntity == null) {
            throw new NoSuchObjectLocalException("Could not load timer with id " + id);
        }
        if (timerEntity.isCalendarTimer()) {
            return new CalendarTimer((CalendarTimerEntity)timerEntity, this);
        }
        return new TimerImpl(timerEntity, this);
    }

    private List<TimerImpl> getActivePersistentTimers() {
        String timedObjectId = this.getInvoker().getTimedObjectId();
        if (this.timerPersistence == null) {
            return Collections.emptyList();
        }
        List<TimerEntity> persistedTimers = ((TimerPersistence)this.timerPersistence.getValue()).loadActiveTimers(timedObjectId);
        ArrayList<TimerImpl> activeTimers = new ArrayList<TimerImpl>();
        for (TimerEntity persistedTimer : persistedTimers) {
            if (ineligibleTimerStates.contains((Object)persistedTimer.getTimerState())) continue;
            TimerImpl activeTimer = null;
            if (persistedTimer.isCalendarTimer()) {
                CalendarTimerEntity calendarTimerEntity = (CalendarTimerEntity)persistedTimer;
                activeTimer = new CalendarTimer(calendarTimerEntity, this);
            } else {
                activeTimer = new TimerImpl(persistedTimer, this);
            }
            activeTimers.add(activeTimer);
        }
        return activeTimers;
    }

    private Serializable clone(Serializable info) throws Exception {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeObject(info);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        Object clonedInfo = objectInputStream.readObject();
        return (Serializable)clonedInfo;
    }

    private boolean doesTimeoutMethodMatch(TimeoutMethod timeoutMethod, String timeoutMethodName, String[] methodParams) {
        if (!timeoutMethod.getMethodName().equals(timeoutMethodName)) {
            return false;
        }
        String[] timeoutMethodParams = timeoutMethod.getMethodParams();
        if (timeoutMethodParams == null && methodParams == null) {
            return true;
        }
        return this.methodParamsMatch(timeoutMethodParams, methodParams);
    }

    private boolean doesScheduleMatch(ScheduleExpression expression1, ScheduleExpression expression2) {
        if (!this.same(expression1.getDayOfMonth(), expression2.getDayOfMonth())) {
            return false;
        }
        if (!this.same(expression1.getDayOfWeek(), expression2.getDayOfWeek())) {
            return false;
        }
        if (!this.same(expression1.getEnd(), expression2.getEnd())) {
            return false;
        }
        if (!this.same(expression1.getHour(), expression2.getHour())) {
            return false;
        }
        if (!this.same(expression1.getMinute(), expression2.getMinute())) {
            return false;
        }
        if (!this.same(expression1.getMonth(), expression2.getMonth())) {
            return false;
        }
        if (!this.same(expression1.getSecond(), expression2.getSecond())) {
            return false;
        }
        if (!this.same(expression1.getStart(), expression2.getStart())) {
            return false;
        }
        if (!this.same(expression1.getTimezone(), expression2.getTimezone())) {
            return false;
        }
        return this.same(expression1.getYear(), expression2.getYear());
    }

    private boolean same(Object i1, Object i2) {
        if (i1 == null && i2 != null) {
            return false;
        }
        if (i2 == null && i1 != null) {
            return false;
        }
        if (i1 == null && i2 == null) {
            return true;
        }
        return i1.equals(i2);
    }

    private boolean isEitherParamNull(Object param1, Object param2) {
        if (param1 != null && param2 == null) {
            return true;
        }
        return param2 != null && param1 == null;
    }

    private boolean methodParamsMatch(String[] methodParams, String[] otherMethodParams) {
        if (this.isEitherParamNull(methodParams, otherMethodParams)) {
            return false;
        }
        if (methodParams.length != otherMethodParams.length) {
            return false;
        }
        for (int i = 0; i < methodParams.length; ++i) {
            if (methodParams[i].equals(otherMethodParams[i])) continue;
            return false;
        }
        return true;
    }

    private void setRollbackOnly() {
        try {
            Transaction tx = this.transactionManager.getTransaction();
            if (tx != null) {
                tx.setRollbackOnly();
            }
        }
        catch (IllegalStateException ise) {
            EjbLogger.ROOT_LOGGER.ignoringException(ise);
        }
        catch (SystemException se) {
            EjbLogger.ROOT_LOGGER.ignoringException(se);
        }
    }

    private void startNewTx() {
        try {
            this.transactionManager.begin();
        }
        catch (Throwable t) {
            throw EjbMessages.MESSAGES.failToStartTransaction(t);
        }
    }

    private void endTx() {
        try {
            Transaction tx = this.transactionManager.getTransaction();
            if (tx == null) {
                throw EjbMessages.MESSAGES.noTransactionInProgress();
            }
            if (tx.getStatus() == 1) {
                this.transactionManager.rollback();
            } else if (tx.getStatus() == 0) {
                this.transactionManager.commit();
            }
        }
        catch (Exception e) {
            throw EjbMessages.MESSAGES.failToEndTransaction(e);
        }
    }

    private void handleLifecycleCallback() {
        if (this.isLifecycleCallbackInvocation() && !this.isSingletonBeanInvocation()) {
            throw EjbMessages.MESSAGES.failToInvokeTimerServiceDoLifecycle();
        }
    }

    public InjectedValue<EJBComponent> getEjbComponentInjectedValue() {
        return this.ejbComponentInjectedValue;
    }

    public InjectedValue<ExecutorService> getExecutorServiceInjectedValue() {
        return this.executorServiceInjectedValue;
    }

    public InjectedValue<Timer> getTimerInjectedValue() {
        return this.timerInjectedValue;
    }

    public InjectedValue<TimerPersistence> getTimerPersistence() {
        return this.timerPersistence;
    }

    public ServiceName getServiceName() {
        return this.serviceName;
    }

    public boolean isStarted() {
        return this.started;
    }

    static {
        logger = Logger.getLogger(TimerServiceImpl.class);
        SERVICE_NAME = ServiceName.of((String[])new String[]{"ejb3", "timerService"});
        HashSet<TimerState> states = new HashSet<TimerState>();
        states.add(TimerState.CANCELED);
        states.add(TimerState.EXPIRED);
        ineligibleTimerStates = Collections.unmodifiableSet(states);
    }

    private class Task
    extends java.util.TimerTask {
        private final Runnable delegate;

        public Task(Runnable delegate) {
            this.delegate = delegate;
        }

        @Override
        public void run() {
            ExecutorService executor = (ExecutorService)TimerServiceImpl.this.executorServiceInjectedValue.getOptionalValue();
            if (executor != null) {
                executor.submit(this.delegate);
            }
        }
    }

    private class TimerCreationTransactionSynchronization
    implements Synchronization {
        private TimerImpl timer;

        public TimerCreationTransactionSynchronization(TimerImpl timer) {
            if (timer == null) {
                throw EjbMessages.MESSAGES.timerIsNull();
            }
            this.timer = timer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCompletion(int status) {
            TimerState timerState;
            if (this.timer.persistent) {
                Map map = TimerServiceImpl.this.persistentWaitingOnTxCompletionTimers;
                synchronized (map) {
                    TimerServiceImpl.this.persistentWaitingOnTxCompletionTimers.remove(this.timer.getTimerHandle());
                }
            }
            if (status == 3) {
                EjbLogger.ROOT_LOGGER.debug("commit timer creation: " + this.timer);
                timerState = this.timer.getState();
                switch (timerState) {
                    case ACTIVE: {
                        this.timer.scheduleTimeout();
                    }
                }
            } else if (status == 4) {
                EjbLogger.ROOT_LOGGER.debug("Rolling back timer creation: " + this.timer);
                timerState = this.timer.getState();
                switch (timerState) {
                    case ACTIVE: {
                        if (this.timer.isPersistent()) {
                            ((TimerPersistence)TimerServiceImpl.this.timerPersistence.getValue()).removeTimer(this.timer.getPersistentState());
                        }
                        this.timer.setTimerState(TimerState.CANCELED);
                    }
                }
            }
        }

        public void beforeCompletion() {
        }
    }
}

