/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.container;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.EntityManager;
import org.jboss.as.jpa.container.AbstractEntityManager;
import org.jboss.as.jpa.spi.SFSBContextHandle;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.DeploymentUnit;

public class SFSBXPCMap {
    public static final AttachmentKey<SFSBXPCMap> ATTACHMENT_KEY = AttachmentKey.create(SFSBXPCMap.class);
    private ConcurrentHashMap<SFSBContextHandle, List<EntityManager>> contextToXPCMap = new ConcurrentHashMap();
    private ConcurrentHashMap<EntityManager, List<SFSBContextHandle>> XPCToContextMap = new ConcurrentHashMap();
    private static ThreadLocal<List<EntityManager>> deferToPostConstruct = new ThreadLocal<List<EntityManager>>(){

        @Override
        protected List<EntityManager> initialValue() {
            return new ArrayList<EntityManager>(1);
        }
    };

    public List<EntityManager> getXPC(SFSBContextHandle beanContextHandle) {
        return this.contextToXPCMap.get(beanContextHandle);
    }

    private List<SFSBContextHandle> getSFSB(EntityManager entityManager) {
        return this.XPCToContextMap.get(entityManager);
    }

    public static void registerPersistenceContext(EntityManager xpc) {
        if (xpc == null) {
            throw new RuntimeException("internal SFSBXPCMap.RegisterPersistenceContext error, null EntityManager passed in");
        }
        if (!(xpc instanceof AbstractEntityManager)) {
            throw new RuntimeException("internal error, XPC needs to be a AbstractEntityManager so that we can get metadata");
        }
        List<EntityManager> store = deferToPostConstruct.get();
        store.add(xpc);
    }

    public void finishRegistrationOfPersistenceContext(SFSBContextHandle current) {
        List<EntityManager> store = deferToPostConstruct.get();
        for (EntityManager em : store) {
            this.register(current, em);
        }
        store.clear();
    }

    public void register(SFSBContextHandle beanContextHandle, EntityManager entityManager) {
        List<SFSBContextHandle> existingList;
        if (!(entityManager instanceof AbstractEntityManager)) {
            throw new RuntimeException("internal error, XPC needs to be a AbstractEntityManager so that we can get metadata");
        }
        List<EntityManager> xpcList = this.contextToXPCMap.get(beanContextHandle);
        if (xpcList == null) {
            xpcList = new ArrayList<EntityManager>();
            xpcList.add(entityManager);
            List<EntityManager> existingList2 = this.contextToXPCMap.put(beanContextHandle, xpcList);
            if (existingList2 != null) {
                throw new RuntimeException("More than one thread is invoking stateful session bean '" + beanContextHandle.getBeanContextHandle() + "' at the same time.");
            }
        } else {
            xpcList.add(entityManager);
        }
        List<SFSBContextHandle> sfsbList = this.XPCToContextMap.get(entityManager);
        if (sfsbList == null && (existingList = this.XPCToContextMap.put(entityManager, sfsbList = new ArrayList<SFSBContextHandle>())) != null) {
            throw new RuntimeException("More than one thread is using EntityManager instance '" + entityManager + "' at the same time.");
        }
        sfsbList.add(beanContextHandle);
    }

    public List<EntityManager> remove(SFSBContextHandle bean) {
        ArrayList<EntityManager> result = null;
        List<EntityManager> xpcList = this.contextToXPCMap.remove(bean);
        if (xpcList != null) {
            for (EntityManager xpc : xpcList) {
                List<SFSBContextHandle> sfsbList = this.XPCToContextMap.get(xpc);
                if (sfsbList == null) continue;
                sfsbList.remove(bean);
                if (sfsbList.size() != 0) continue;
                if (result == null) {
                    result = new ArrayList<EntityManager>();
                }
                result.add(xpc);
                this.XPCToContextMap.remove(xpc);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SFSBXPCMap getXpcMap(DeploymentUnit deploymentUnit) {
        DeploymentUnit top = deploymentUnit.getParent() == null ? deploymentUnit : deploymentUnit.getParent();
        SFSBXPCMap sfsbMap = (SFSBXPCMap)top.getAttachment(ATTACHMENT_KEY);
        if (sfsbMap == null) {
            DeploymentUnit deploymentUnit2 = top;
            synchronized (deploymentUnit2) {
                sfsbMap = (SFSBXPCMap)top.getAttachment(ATTACHMENT_KEY);
                if (sfsbMap == null) {
                    sfsbMap = new SFSBXPCMap();
                    top.putAttachment(ATTACHMENT_KEY, (Object)sfsbMap);
                }
            }
        }
        return sfsbMap;
    }
}

