/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.se;

import java.util.Set;
import java.util.concurrent.Callable;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.proxy.ClassLoaderAdapterBuilder;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.se.BootstrapClassLoader;
import org.jboss.forge.furnace.util.Sets;

public class FurnaceFactory {
    public static Furnace getInstance() {
        try {
            BootstrapClassLoader loader = new BootstrapClassLoader("bootpath");
            return FurnaceFactory.getInstance(FurnaceFactory.class.getClassLoader(), loader);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Furnace getInstance(ClassLoader clientLoader) {
        BootstrapClassLoader loader = new BootstrapClassLoader("bootpath");
        return FurnaceFactory.getInstance(clientLoader, loader);
    }

    public static Furnace getInstance(ClassLoader clientLoader, ClassLoader furnaceLoader) {
        try {
            Class<?> furnaceType = furnaceLoader.loadClass("org.jboss.forge.furnace.impl.FurnaceImpl");
            Object instance = furnaceType.newInstance();
            final Furnace furnace = (Furnace)ClassLoaderAdapterBuilder.callingLoader((ClassLoader)clientLoader).delegateLoader(furnaceLoader).enhance(instance, new Class[]{Furnace.class});
            Callable<Set<ClassLoader>> whitelistCallback = new Callable<Set<ClassLoader>>(){
                volatile long lastRegistryVersion = -1L;
                final Set<ClassLoader> result = Sets.getConcurrentSet();

                @Override
                public Set<ClassLoader> call() throws Exception {
                    long registryVersion;
                    if (furnace.getStatus().isStarted() && (registryVersion = furnace.getAddonRegistry(new AddonRepository[0]).getVersion()) != this.lastRegistryVersion) {
                        this.result.clear();
                        this.lastRegistryVersion = registryVersion;
                        for (Addon addon : furnace.getAddonRegistry(new AddonRepository[0]).getAddons()) {
                            ClassLoader classLoader = addon.getClassLoader();
                            if (classLoader == null) continue;
                            this.result.add(classLoader);
                        }
                    }
                    return this.result;
                }
            };
            return (Furnace)ClassLoaderAdapterBuilder.callingLoader((ClassLoader)clientLoader).delegateLoader(furnaceLoader).whitelist((Callable)whitelistCallback).enhance(instance, new Class[]{Furnace.class});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

