/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster.model;

import java.util.Arrays;
import java.util.Objects;
import org.jboss.forge.roaster.model.VisibilityScoped;
import org.jboss.forge.roaster.model.source.VisibilityScopedSource;

public enum Visibility {
    PUBLIC("public"),
    PROTECTED("protected"),
    PRIVATE("private"),
    PACKAGE_PRIVATE("");

    private final String scope;

    private Visibility(String scope) {
        this.scope = scope;
    }

    public String scope() {
        return this.scope;
    }

    public static Visibility getFrom(VisibilityScoped target) {
        Objects.requireNonNull(target, "VisibilityScoped<T> target must not be null.");
        if (target.isPackagePrivate()) {
            return PACKAGE_PRIVATE;
        }
        if (target.isPrivate()) {
            return PRIVATE;
        }
        if (target.isPublic()) {
            return PUBLIC;
        }
        if (target.isProtected()) {
            return PROTECTED;
        }
        throw new IllegalStateException(VisibilityScoped.class.getSimpleName() + " target does not comply with visibility scoping. Must be one of " + Arrays.toString((Object[])Visibility.values()) + "[ " + target + "]");
    }

    public String toString() {
        return this.scope;
    }

    public static <T extends VisibilityScopedSource<?>> T set(T target, Visibility scope) {
        Objects.requireNonNull(target, "VisibilityScoped<T> target must not be null.");
        Objects.requireNonNull(scope, "Visibility scope must not be null");
        switch (scope) {
            case PRIVATE: {
                target.setPrivate();
                break;
            }
            case PACKAGE_PRIVATE: {
                target.setPackagePrivate();
                break;
            }
            case PROTECTED: {
                target.setProtected();
                break;
            }
            case PUBLIC: {
                target.setPublic();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown Visibility scope.");
            }
        }
        return target;
    }
}

