/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster.model.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import org.jboss.forge.roaster.ParserException;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.JavaCore;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.compiler.IProblem;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ASTNode;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.BodyDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.CompilationUnit;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.EnumDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ImportDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Javadoc;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Modifier;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.PackageDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.TypeDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.TypeParameter;
import org.jboss.forge.roaster._shade.org.eclipse.jface.text.Document;
import org.jboss.forge.roaster._shade.org.eclipse.text.edits.TextEdit;
import org.jboss.forge.roaster.model.Annotation;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.SyntaxError;
import org.jboss.forge.roaster.model.Type;
import org.jboss.forge.roaster.model.Visibility;
import org.jboss.forge.roaster.model.VisibilityScoped;
import org.jboss.forge.roaster.model.ast.AnnotationAccessor;
import org.jboss.forge.roaster.model.ast.ModifierAccessor;
import org.jboss.forge.roaster.model.ast.TypeDeclarationFinderVisitor;
import org.jboss.forge.roaster.model.impl.ImportImpl;
import org.jboss.forge.roaster.model.impl.JavaDocImpl;
import org.jboss.forge.roaster.model.impl.SyntaxErrorImpl;
import org.jboss.forge.roaster.model.impl.TypeImpl;
import org.jboss.forge.roaster.model.source.AnnotationSource;
import org.jboss.forge.roaster.model.source.AnnotationTargetSource;
import org.jboss.forge.roaster.model.source.Import;
import org.jboss.forge.roaster.model.source.JavaDocSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.source.StaticCapableSource;
import org.jboss.forge.roaster.model.source.TypeHolderSource;
import org.jboss.forge.roaster.model.source.VisibilityScopedSource;
import org.jboss.forge.roaster.model.util.Formatter;
import org.jboss.forge.roaster.model.util.Strings;
import org.jboss.forge.roaster.model.util.Types;
import org.jboss.forge.roaster.spi.JavaParserImpl;
import org.jboss.forge.roaster.spi.WildcardImportResolver;

public abstract class AbstractJavaSource<O extends JavaSource<O>>
implements JavaSource<O>,
TypeHolderSource<O>,
StaticCapableSource<O> {
    private final AnnotationAccessor<O, O> annotations = new AnnotationAccessor();
    private final ModifierAccessor modifiers = new ModifierAccessor();
    protected final Document document;
    protected final CompilationUnit unit;
    protected final BodyDeclaration body;
    protected final JavaSource<?> enclosingType;
    private static List<WildcardImportResolver> resolvers;

    protected AbstractJavaSource(JavaSource<?> enclosingType, Document document, CompilationUnit unit, BodyDeclaration body) {
        this.enclosingType = enclosingType == null ? this : enclosingType;
        this.document = document;
        this.unit = unit;
        this.body = body;
    }

    public JavaSource<?> getEnclosingType() {
        return this.enclosingType;
    }

    public AnnotationSource<O> addAnnotation() {
        return this.annotations.addAnnotation((AnnotationTargetSource<O, O>)this, this.getBodyDeclaration());
    }

    public AnnotationSource<O> addAnnotation(Class<? extends java.lang.annotation.Annotation> clazz) {
        return this.annotations.addAnnotation((AnnotationTargetSource<O, O>)this, (ASTNode)this.getBodyDeclaration(), clazz.getName());
    }

    public AnnotationSource<O> addAnnotation(String className) {
        return this.annotations.addAnnotation((AnnotationTargetSource<O, O>)this, (ASTNode)this.getBodyDeclaration(), className);
    }

    public List<AnnotationSource<O>> getAnnotations() {
        return this.annotations.getAnnotations((AnnotationTargetSource<O, O>)this, this.getBodyDeclaration());
    }

    public boolean hasAnnotation(Class<? extends java.lang.annotation.Annotation> type) {
        return this.annotations.hasAnnotation(this, this.getBodyDeclaration(), type.getName());
    }

    public boolean hasAnnotation(String type) {
        return this.annotations.hasAnnotation(this, this.getBodyDeclaration(), type);
    }

    public O removeAnnotation(Annotation<O> annotation) {
        return (O)this.annotations.removeAnnotation(this, this.getBodyDeclaration(), annotation);
    }

    public void removeAllAnnotations() {
        this.annotations.removeAllAnnotations(this.getBodyDeclaration());
    }

    public AnnotationSource<O> getAnnotation(Class<? extends java.lang.annotation.Annotation> type) {
        return this.annotations.getAnnotation((AnnotationTargetSource<O, O>)this, (ASTNode)this.getBodyDeclaration(), (Class<java.lang.annotation.Annotation>)type);
    }

    public AnnotationSource<O> getAnnotation(String type) {
        return this.annotations.getAnnotation((AnnotationTargetSource<O, O>)this, (ASTNode)this.getBodyDeclaration(), type);
    }

    public Import addImport(Class<?> type) {
        return this.addImport(type.getCanonicalName());
    }

    public <T extends JavaType<?>> Import addImport(T type) {
        String qualifiedName = type.getQualifiedName();
        return this.addImport(qualifiedName);
    }

    public Import addImport(Import imprt) {
        return (Import)this.addImport(imprt.getQualifiedName()).setStatic(imprt.isStatic());
    }

    public Import addImport(String className) {
        Import imprt;
        String strippedClassName = Types.stripGenerics((String)Types.stripArray((String)className));
        if (Types.isSimpleName((String)strippedClassName) && !this.hasImport(strippedClassName)) {
            throw new IllegalArgumentException("Cannot import class without a package [" + strippedClassName + "]");
        }
        if (!this.hasImport(strippedClassName) && this.validImport(strippedClassName)) {
            imprt = new ImportImpl(this).setName(strippedClassName);
            this.unit.imports().add(imprt.getInternal());
        } else if (this.hasImport(strippedClassName)) {
            imprt = this.getImport(strippedClassName);
        } else {
            throw new IllegalArgumentException("Attempted to import the illegal type [" + strippedClassName + "]");
        }
        return imprt;
    }

    public Import getImport(String className) {
        List<Import> imports = this.getImports();
        for (Import imprt : imports) {
            if (!imprt.getQualifiedName().equals(className) && !imprt.getSimpleName().equals(className)) continue;
            return imprt;
        }
        return null;
    }

    public Import getImport(Class<?> type) {
        return this.getImport(type.getName());
    }

    public <T extends JavaType<?>> Import getImport(T type) {
        return this.getImport(type.getQualifiedName());
    }

    public Import getImport(Import imprt) {
        return this.getImport(imprt.getQualifiedName());
    }

    public List<Import> getImports() {
        ArrayList<ImportImpl> results = new ArrayList<ImportImpl>();
        for (ImportDeclaration i : this.unit.imports()) {
            results.add(new ImportImpl(this, i));
        }
        return Collections.unmodifiableList(results);
    }

    public boolean hasImport(Class<?> type) {
        return this.hasImport(type.getName());
    }

    public <T extends JavaType<T>> boolean hasImport(T type) {
        return this.hasImport(type.getQualifiedName());
    }

    public boolean hasImport(Import imprt) {
        return this.hasImport(imprt.getQualifiedName());
    }

    public boolean hasImport(String type) {
        String resultType = type;
        if (Types.isArray((String)type)) {
            resultType = Types.stripArray((String)type);
        }
        if (Types.isGeneric((String)type)) {
            resultType = Types.stripGenerics((String)type);
        }
        return this.getImport(resultType) != null;
    }

    public boolean requiresImport(Class<?> type) {
        return this.requiresImport(type.getName());
    }

    public boolean requiresImport(String type) {
        String resultType = type;
        if (Types.isArray((String)resultType)) {
            resultType = Types.stripArray((String)type);
        }
        if (Types.isGeneric((String)resultType)) {
            resultType = Types.stripGenerics((String)resultType);
        }
        return this.validImport(resultType) && !this.hasImport(resultType) && !Types.isJavaLang((String)resultType) && !Strings.areEqual((String)this.getPackage(), (String)Types.getPackage((String)resultType));
    }

    public String resolveType(String type) {
        String original = type;
        String result = type;
        if (Types.isArray((String)result)) {
            original = Types.stripArray((String)result);
            result = Types.stripArray((String)result);
        }
        if (Types.isGeneric((String)result)) {
            original = Types.stripGenerics((String)result);
            result = Types.stripGenerics((String)result);
        }
        if (Types.isPrimitive((String)result)) {
            return result;
        }
        if (Types.isSimpleName((String)result)) {
            if (!this.hasImport(result) && Types.isJavaLang((String)result)) {
                result = "java.lang." + result;
            }
            if (result.equals(original)) {
                for (Import imprt : this.getImports()) {
                    if (!Types.areEquivalent((String)result, (String)imprt.getQualifiedName())) continue;
                    result = imprt.getQualifiedName();
                    break;
                }
            }
        }
        if (Types.isSimpleName((String)result)) {
            for (Import imprt : this.getImports()) {
                WildcardImportResolver r;
                if (!imprt.isWildcard()) continue;
                Iterator<WildcardImportResolver> iterator = this.getImportResolvers().iterator();
                while (iterator.hasNext() && !Types.isQualified((String)(result = (r = iterator.next()).resolve((JavaType)this, result)))) {
                }
            }
        }
        if (Types.isSimpleName((String)result) && this.getPackage() != null) {
            result = this.getPackage() + "." + result;
        }
        return result;
    }

    private List<WildcardImportResolver> getImportResolvers() {
        if (resolvers == null) {
            resolvers = new ArrayList<WildcardImportResolver>();
            for (WildcardImportResolver r : ServiceLoader.load(WildcardImportResolver.class, this.getClass().getClassLoader())) {
                resolvers.add(r);
            }
        }
        if (resolvers.isEmpty()) {
            throw new IllegalStateException("No instances of [" + WildcardImportResolver.class.getName() + "] were found on the classpath.");
        }
        return resolvers;
    }

    private boolean validImport(String type) {
        return !Strings.isNullOrEmpty((String)type) && !Types.isPrimitive((String)type) && !Strings.isNullOrEmpty((String)Types.getPackage((String)type));
    }

    public O removeImport(String name) {
        for (Import i : this.getImports()) {
            if (!i.getQualifiedName().equals(name)) continue;
            this.removeImport(i);
            break;
        }
        return (O)this;
    }

    public O removeImport(Class<?> clazz) {
        return this.removeImport((JavaType)clazz.getName());
    }

    public <T extends JavaType<?>> O removeImport(T type) {
        return this.removeImport((T)type.getQualifiedName());
    }

    public O removeImport(Import imprt) {
        Object internal = imprt.getInternal();
        if (this.unit.imports().contains(internal)) {
            this.unit.imports().remove(internal);
        }
        return (O)this;
    }

    protected AbstractTypeDeclaration getBodyDeclaration() {
        if (this.body instanceof AbstractTypeDeclaration) {
            return (AbstractTypeDeclaration)this.body;
        }
        throw new ParserException("Source body was not of the expected type.");
    }

    public String getName() {
        return this.getBodyDeclaration().getName().getIdentifier();
    }

    public O setName(String name) {
        AbstractTypeDeclaration typeDeclaration = this.getBodyDeclaration();
        TypeImpl<AbstractJavaSource> type = new TypeImpl<AbstractJavaSource>(this, null, name);
        typeDeclaration.setName(this.unit.getAST().newSimpleName(type.getName()));
        if (typeDeclaration instanceof TypeDeclaration) {
            TypeDeclaration td = (TypeDeclaration)typeDeclaration;
            for (Type<AbstractJavaSource> arg : type.getTypeArguments()) {
                TypeParameter typeParameter = this.unit.getAST().newTypeParameter();
                typeParameter.setName(this.unit.getAST().newSimpleName(arg.getName()));
                td.typeParameters().add(typeParameter);
            }
        }
        return this.updateTypeNames(name);
    }

    public String getCanonicalName() {
        String result = this.getName();
        for (AbstractJavaSource enclosingTypeLocal = this; enclosingTypeLocal != enclosingTypeLocal.getEnclosingType(); enclosingTypeLocal = enclosingTypeLocal.getEnclosingType()) {
            result = enclosingTypeLocal.getName() + "." + result;
        }
        if (!Strings.isNullOrEmpty((String)this.getPackage())) {
            result = this.getPackage() + "." + result;
        }
        return result;
    }

    protected abstract O updateTypeNames(String var1);

    public String getQualifiedName() {
        String result = this.getName();
        for (AbstractJavaSource enclosingTypeLocal = this; enclosingTypeLocal != enclosingTypeLocal.getEnclosingType(); enclosingTypeLocal = enclosingTypeLocal.getEnclosingType()) {
            result = enclosingTypeLocal.getName() + "$" + result;
        }
        if (!Strings.isNullOrEmpty((String)this.getPackage())) {
            result = this.getPackage() + "." + result;
        }
        return result;
    }

    public String getPackage() {
        PackageDeclaration pkg = this.unit.getPackage();
        if (pkg != null) {
            return pkg.getName().getFullyQualifiedName();
        }
        return null;
    }

    public O setPackage(String name) {
        if (this.unit.getPackage() == null) {
            this.unit.setPackage(this.unit.getAST().newPackageDeclaration());
        }
        this.unit.getPackage().setName(this.unit.getAST().newName(name));
        return (O)this;
    }

    public O setDefaultPackage() {
        this.unit.setPackage(null);
        return (O)this;
    }

    public boolean isDefaultPackage() {
        return this.unit.getPackage() == null;
    }

    public boolean isPackagePrivate() {
        return !this.isPublic() && !this.isPrivate() && !this.isProtected();
    }

    public O setPackagePrivate() {
        this.modifiers.clearVisibility(this.getBodyDeclaration());
        return (O)this;
    }

    public boolean isPublic() {
        return this.modifiers.hasModifier(this.getBodyDeclaration(), Modifier.ModifierKeyword.PUBLIC_KEYWORD);
    }

    public O setPublic() {
        this.modifiers.clearVisibility(this.getBodyDeclaration());
        this.modifiers.addModifier(this.getBodyDeclaration(), Modifier.ModifierKeyword.PUBLIC_KEYWORD);
        return (O)this;
    }

    public boolean isPrivate() {
        return this.modifiers.hasModifier(this.getBodyDeclaration(), Modifier.ModifierKeyword.PRIVATE_KEYWORD);
    }

    public O setPrivate() {
        this.modifiers.clearVisibility(this.getBodyDeclaration());
        this.modifiers.addModifier(this.getBodyDeclaration(), Modifier.ModifierKeyword.PRIVATE_KEYWORD);
        return (O)this;
    }

    public boolean isProtected() {
        return this.modifiers.hasModifier(this.getBodyDeclaration(), Modifier.ModifierKeyword.PROTECTED_KEYWORD);
    }

    public O setProtected() {
        this.modifiers.clearVisibility(this.getBodyDeclaration());
        this.modifiers.addModifier(this.getBodyDeclaration(), Modifier.ModifierKeyword.PROTECTED_KEYWORD);
        return (O)this;
    }

    public Visibility getVisibility() {
        return Visibility.getFrom((VisibilityScoped)this);
    }

    public O setVisibility(Visibility scope) {
        return (O)((JavaSource)Visibility.set((VisibilityScopedSource)this, (Visibility)scope));
    }

    public String toString() {
        return Formatter.format(this.toUnformattedString());
    }

    public String toUnformattedString() {
        Document documentLocal = new Document(this.document.get());
        try {
            Hashtable options = JavaCore.getOptions();
            options.put("org.jboss.forge.roaster._shade.org.eclipse.jdt.core.compiler.source", "1.7");
            options.put("org.jboss.forge.roaster._shade.org.eclipse.jdt.core.encoding", "UTF-8");
            TextEdit edit = this.unit.rewrite(documentLocal, options);
            edit.apply(documentLocal);
        }
        catch (Exception e) {
            throw new ParserException("Could not modify source: " + this.unit.toString(), (Throwable)e);
        }
        return documentLocal.get();
    }

    public Object getInternal() {
        return this.unit;
    }

    public O getOrigin() {
        return (O)this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.body == null ? 0 : this.body.hashCode());
        result = 31 * result + (this.document == null ? 0 : this.document.hashCode());
        result = 31 * result + (this.enclosingType == null || this.enclosingType == this ? 0 : this.enclosingType.hashCode());
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractJavaSource other = (AbstractJavaSource)obj;
        if (this.body == null ? other.body != null : !this.body.equals(other.body)) {
            return false;
        }
        if (this.document == null ? other.document != null : !this.document.equals(other.document)) {
            return false;
        }
        if (this.enclosingType == null ? other.enclosingType != null : !this.enclosingType.equals(other.enclosingType)) {
            return false;
        }
        return !(this.unit == null ? other.unit != null : !this.unit.equals(other.unit));
    }

    public List<SyntaxError> getSyntaxErrors() {
        ArrayList<SyntaxError> result = new ArrayList<SyntaxError>();
        IProblem[] problems = this.unit.getProblems();
        if (problems != null) {
            for (IProblem problem : problems) {
                result.add(new SyntaxErrorImpl((JavaType<?>)this, problem));
            }
        }
        return result;
    }

    public boolean hasSyntaxErrors() {
        return !this.getSyntaxErrors().isEmpty();
    }

    public boolean isClass() {
        AbstractTypeDeclaration declaration = this.getBodyDeclaration();
        return declaration instanceof TypeDeclaration && !((TypeDeclaration)declaration).isInterface();
    }

    public boolean isEnum() {
        AbstractTypeDeclaration declaration = this.getBodyDeclaration();
        return declaration instanceof EnumDeclaration;
    }

    public boolean isInterface() {
        AbstractTypeDeclaration declaration = this.getBodyDeclaration();
        return declaration instanceof TypeDeclaration && ((TypeDeclaration)declaration).isInterface();
    }

    public boolean isAnnotation() {
        AbstractTypeDeclaration declaration = this.getBodyDeclaration();
        return declaration instanceof AnnotationTypeDeclaration;
    }

    public List<JavaSource<?>> getNestedTypes() {
        List<AbstractTypeDeclaration> declarations = this.getNestedDeclarations(this.body);
        ArrayList result = new ArrayList();
        for (AbstractTypeDeclaration declaration : declarations) {
            result.add(JavaParserImpl.getJavaSource(this, this.document, this.unit, declaration));
        }
        return result;
    }

    public boolean hasNestedType(JavaType<?> type) {
        for (JavaSource<?> nested : this.getNestedTypes()) {
            if (!Strings.areEqual((String)nested.getQualifiedName(), (String)type.getQualifiedName()) && !Strings.areEqual((String)nested.getName(), (String)type.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean hasNestedType(String name) {
        for (JavaSource<?> nested : this.getNestedTypes()) {
            if (!Strings.areEqual((String)nested.getName(), (String)name) && !Strings.areEqual((String)nested.getQualifiedName(), (String)name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNestedType(Class<?> type) {
        for (JavaSource<?> nested : this.getNestedTypes()) {
            if (!Strings.areEqual((String)nested.getName(), (String)type.getSimpleName()) && !Strings.areEqual((String)nested.getQualifiedName(), (String)type.getName())) continue;
            return true;
        }
        return false;
    }

    public JavaSource<?> getNestedType(String name) {
        for (JavaSource<?> nested : this.getNestedTypes()) {
            if (!Strings.areEqual((String)nested.getName(), (String)name) && !Strings.areEqual((String)nested.getQualifiedName(), (String)name)) continue;
            return nested;
        }
        return null;
    }

    public <NESTED_TYPE extends JavaSource<?>> NESTED_TYPE addNestedType(NESTED_TYPE type) {
        if (!(type instanceof AbstractJavaSource)) {
            throw new IllegalArgumentException("type must be an AbstractJavaSource instance");
        }
        List bodyDeclarations = this.getBodyDeclaration().bodyDeclarations();
        BodyDeclaration nestedBody = ((AbstractJavaSource)type).body;
        bodyDeclarations.add(ASTNode.copySubtree(this.unit.getAST(), nestedBody));
        return (NESTED_TYPE)this.getNestedType(type.getName());
    }

    public O removeNestedType(JavaSource<?> type) {
        if (type instanceof AbstractJavaSource) {
            BodyDeclaration bodyDeclaration = ((AbstractJavaSource)type).body;
            List bodyDeclarations = this.getBodyDeclaration().bodyDeclarations();
            bodyDeclarations.remove(bodyDeclaration);
        }
        return (O)this;
    }

    public <NESTED_TYPE extends JavaSource<?>> NESTED_TYPE addNestedType(Class<NESTED_TYPE> type) {
        JavaSource nestedType = Roaster.create(type);
        return (NESTED_TYPE)this.addNestedType(nestedType);
    }

    public <NESTED_TYPE extends JavaSource<?>> NESTED_TYPE addNestedType(String declaration) {
        JavaSource nestedType = (JavaSource)Roaster.parse(JavaSource.class, (String)declaration);
        return (NESTED_TYPE)this.addNestedType(nestedType);
    }

    public JavaDocSource<O> getJavaDoc() {
        Javadoc javadoc = this.body.getJavadoc();
        if (javadoc == null) {
            javadoc = this.body.getAST().newJavadoc();
            this.body.setJavadoc(javadoc);
        }
        return new JavaDocImpl<AbstractJavaSource>(this, javadoc);
    }

    public O removeJavaDoc() {
        this.body.setJavadoc(null);
        return (O)this;
    }

    public boolean hasJavaDoc() {
        return this.body.getJavadoc() != null;
    }

    public boolean isStatic() {
        return this.modifiers.hasModifier(this.getBodyDeclaration(), Modifier.ModifierKeyword.STATIC_KEYWORD);
    }

    public O setStatic(boolean _static) {
        if (_static) {
            this.modifiers.addModifier(this.getBodyDeclaration(), Modifier.ModifierKeyword.STATIC_KEYWORD);
        } else {
            this.modifiers.removeModifier(this.getBodyDeclaration(), Modifier.ModifierKeyword.STATIC_KEYWORD);
        }
        return (O)this;
    }

    private List<AbstractTypeDeclaration> getNestedDeclarations(BodyDeclaration body) {
        TypeDeclarationFinderVisitor typeDeclarationFinder = new TypeDeclarationFinderVisitor();
        body.accept(typeDeclarationFinder);
        List<AbstractTypeDeclaration> declarations = typeDeclarationFinder.getTypeDeclarations();
        ArrayList<AbstractTypeDeclaration> result = new ArrayList<AbstractTypeDeclaration>(declarations);
        if (!declarations.isEmpty()) {
            result.remove(declarations.remove(0));
            for (AbstractTypeDeclaration declaration : declarations) {
                result.removeAll(this.getNestedDeclarations(declaration));
            }
        }
        return result;
    }

    public Import addImport(Type<?> type) {
        Import imprt = this.requiresImport(type.getQualifiedName()) ? this.addImport(type.getQualifiedName()) : this.getImport(type.getSimpleName());
        for (Type arg : type.getTypeArguments()) {
            if (arg.isWildcard() || !arg.isQualified()) continue;
            this.addImport(arg);
        }
        return imprt;
    }
}

