/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster.model.impl;

import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.AnnotatableType;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.BodyDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.CompilationUnit;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Modifier;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Name;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ParameterizedType;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.SimpleName;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Type;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.TypeDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jface.text.Document;
import org.jboss.forge.roaster.model.JavaClass;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.ast.ModifierAccessor;
import org.jboss.forge.roaster.model.impl.AbstractGenericCapableJavaSource;
import org.jboss.forge.roaster.model.impl.JDTHelper;
import org.jboss.forge.roaster.model.impl.TypeImpl;
import org.jboss.forge.roaster.model.source.Import;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.source.MethodHolderSource;
import org.jboss.forge.roaster.model.source.MethodSource;
import org.jboss.forge.roaster.model.util.Methods;
import org.jboss.forge.roaster.model.util.Types;

public class JavaClassImpl
extends AbstractGenericCapableJavaSource<JavaClassSource>
implements JavaClassSource {
    private final ModifierAccessor modifiers = new ModifierAccessor();

    public JavaClassImpl(JavaSource<?> enclosingType, Document document, CompilationUnit unit, BodyDeclaration body) {
        super(enclosingType, document, unit, body);
    }

    @Override
    protected JavaClassSource updateTypeNames(String newName) {
        for (MethodSource m : this.getMethods()) {
            if (!m.isConstructor()) continue;
            m.setConstructor(false);
            m.setConstructor(true);
        }
        return this;
    }

    public boolean isAbstract() {
        return this.modifiers.hasModifier(this.getBodyDeclaration(), Modifier.ModifierKeyword.ABSTRACT_KEYWORD);
    }

    public JavaClassSource setAbstract(boolean abstrct) {
        if (abstrct) {
            this.modifiers.addModifier(this.getBodyDeclaration(), Modifier.ModifierKeyword.ABSTRACT_KEYWORD);
        } else {
            this.modifiers.removeModifier(this.getBodyDeclaration(), Modifier.ModifierKeyword.ABSTRACT_KEYWORD);
        }
        return this;
    }

    public boolean isFinal() {
        return this.modifiers.hasModifier(this.getBodyDeclaration(), Modifier.ModifierKeyword.FINAL_KEYWORD);
    }

    public JavaClassSource setFinal(boolean finl) {
        if (finl) {
            this.modifiers.addModifier(this.getBodyDeclaration(), Modifier.ModifierKeyword.FINAL_KEYWORD);
        } else {
            this.modifiers.removeModifier(this.getBodyDeclaration(), Modifier.ModifierKeyword.FINAL_KEYWORD);
        }
        return this;
    }

    public boolean isLocalClass() {
        return JDTHelper.isLocalClass(this.getBodyDeclaration());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.toString() == null ? 0 : this.unit.toString().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass() == obj.getClass() && this.toString().equals(obj.toString());
    }

    public String getSuperType() {
        Object superType = this.getBodyDeclaration().getStructuralProperty(TypeDeclaration.SUPERCLASS_TYPE_PROPERTY);
        if (superType == null) {
            superType = Object.class.getName();
        }
        return this.resolveType(superType.toString()) + Types.getGenerics((String)superType.toString());
    }

    public JavaClassSource setSuperType(JavaType<?> type) {
        if (this.handleNullSuperType(type)) {
            return this;
        }
        return this.setSuperType(type.getQualifiedName());
    }

    public JavaClassSource setSuperType(Class<?> type) {
        if (this.handleNullSuperType(type)) {
            return this;
        }
        if (type.isAnnotation() || type.isEnum() || type.isInterface() || type.isPrimitive()) {
            throw new IllegalArgumentException("Super-type must be a Class type, but was [" + type.getName() + "]");
        }
        return this.setSuperType(type.getName());
    }

    public JavaClassSource extendSuperType(Class<?> type) {
        this.setSuperType(type);
        for (MethodSource methodSource : Methods.implementAbstractMethods(type, (MethodHolderSource)this)) {
            methodSource.addAnnotation(Override.class);
        }
        return this;
    }

    public JavaClassSource extendSuperType(JavaClass<?> type) {
        this.setSuperType((JavaType<?>)type);
        for (MethodSource methodSource : Methods.implementAbstractMethods(type, (MethodHolderSource)this)) {
            methodSource.addAnnotation(Override.class);
        }
        return this;
    }

    public JavaClassSource setSuperType(String type) {
        if (this.handleNullSuperType(type)) {
            return this;
        }
        if (Types.isGeneric((String)type)) {
            String typeD = Types.stripGenerics((String)type);
            String simpleTypeDName = Types.toSimpleName((String)typeD);
            ParameterizedType pt = this.body.getAST().newParameterizedType(this.body.getAST().newSimpleType(this.body.getAST().newSimpleName(simpleTypeDName)));
            this.addImport(type);
            for (String typeP : Types.splitGenerics((String)type)) {
                Type t = TypeImpl.fromString(Types.toSimpleName((String)typeP.trim()), this.body.getAST());
                pt.typeArguments().add(t);
            }
            this.getBodyDeclaration().setStructuralProperty(TypeDeclaration.SUPERCLASS_TYPE_PROPERTY, pt);
        } else {
            AnnotatableType superType;
            SimpleName simpleName = this.body.getAST().newSimpleName(Types.toSimpleName((String)type));
            Import imprt = this.addImport(type);
            if (imprt == null && !Types.isSimpleName((String)type)) {
                Name qualifier = this.body.getAST().newName(Types.getPackage((String)type));
                superType = this.body.getAST().newNameQualifiedType(qualifier, simpleName);
            } else {
                superType = this.body.getAST().newSimpleType(simpleName);
            }
            this.getBodyDeclaration().setStructuralProperty(TypeDeclaration.SUPERCLASS_TYPE_PROPERTY, superType);
        }
        return this;
    }

    private boolean handleNullSuperType(String type) {
        if (type == null || type.trim().isEmpty()) {
            return this.handleNullSuperType((Object)null);
        }
        return false;
    }

    private boolean handleNullSuperType(Object type) {
        if (type == null) {
            this.getBodyDeclaration().setStructuralProperty(TypeDeclaration.SUPERCLASS_TYPE_PROPERTY, null);
            return true;
        }
        return false;
    }
}

