/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.recovery.arjunacore;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.objectstore.RecoveryStore;
import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.arjuna.recovery.RecoveryModule;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.internal.arjuna.common.UidHelper;
import com.arjuna.ats.internal.jta.Implementations;
import com.arjuna.ats.internal.jta.recovery.arjunacore.RecoveryXids;
import com.arjuna.ats.internal.jta.recovery.arjunacore.XARecoveryResourceManagerImple;
import com.arjuna.ats.internal.jta.resources.arjunacore.XAResourceRecord;
import com.arjuna.ats.jta.common.jtaPropertyManager;
import com.arjuna.ats.jta.logging.jtaLogger;
import com.arjuna.ats.jta.recovery.SerializableXAResourceDeserializer;
import com.arjuna.ats.jta.recovery.XARecoveryResource;
import com.arjuna.ats.jta.recovery.XARecoveryResourceManager;
import com.arjuna.ats.jta.recovery.XAResourceOrphanFilter;
import com.arjuna.ats.jta.recovery.XAResourceRecovery;
import com.arjuna.ats.jta.recovery.XAResourceRecoveryHelper;
import com.arjuna.ats.jta.utils.XAHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XARecoveryModule
implements RecoveryModule {
    private RecoveryStore _recoveryStore = StoreManager.getRecoveryStore();
    private InputObjectState _uids = new InputObjectState();
    private boolean requireFirstPass = true;
    private final List<XAResourceRecovery> _xaRecoverers;
    private final List<XAResourceRecoveryHelper> _xaResourceRecoveryHelpers = new LinkedList<XAResourceRecoveryHelper>();
    private final List<XAResourceOrphanFilter> _xaResourceOrphanFilters;
    private Hashtable _failures = null;
    private Hashtable<XAResource, RecoveryXids> _xidScans = null;
    private XARecoveryResourceManager _recoveryManagerClass = null;
    private String _logName = null;
    private List<SerializableXAResourceDeserializer> _seriablizableXAResourceDeserializers = new ArrayList<SerializableXAResourceDeserializer>();

    public XARecoveryModule() {
        this(new XARecoveryResourceManagerImple(), "Local XARecoveryModule");
        Implementations.initialise();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addXAResourceRecoveryHelper(XAResourceRecoveryHelper xaResourceRecoveryHelper) {
        List<XAResourceRecoveryHelper> list2 = this._xaResourceRecoveryHelpers;
        synchronized (list2) {
            if (!this._xaResourceRecoveryHelpers.contains(xaResourceRecoveryHelper)) {
                this._xaResourceRecoveryHelpers.add(xaResourceRecoveryHelper);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeXAResourceRecoveryHelper(XAResourceRecoveryHelper xaResourceRecoveryHelper) {
        List<XAResourceRecoveryHelper> list2 = this._xaResourceRecoveryHelpers;
        synchronized (list2) {
            this._xaResourceRecoveryHelpers.remove(xaResourceRecoveryHelper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addXAResourceOrphanFilter(XAResourceOrphanFilter xaResourceOrphanFilter) {
        List<XAResourceOrphanFilter> list2 = this._xaResourceOrphanFilters;
        synchronized (list2) {
            if (!this._xaResourceOrphanFilters.contains(xaResourceOrphanFilter)) {
                this._xaResourceOrphanFilters.add(xaResourceOrphanFilter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeXAResourceOrphanFilter(XAResourceOrphanFilter xaResourceOrphanFilter) {
        List<XAResourceOrphanFilter> list2 = this._xaResourceOrphanFilters;
        synchronized (list2) {
            this._xaResourceOrphanFilters.remove(xaResourceOrphanFilter);
        }
    }

    public void addSerializableXAResourceDeserializer(SerializableXAResourceDeserializer serializableXAResourceDeserializer) {
        this._seriablizableXAResourceDeserializers.add(serializableXAResourceDeserializer);
    }

    public List<SerializableXAResourceDeserializer> getSeriablizableXAResourceDeserializers() {
        return this._seriablizableXAResourceDeserializers;
    }

    @Override
    public synchronized void periodicWorkFirstPass() {
        if (!this.requireFirstPass) {
            return;
        }
        if (jtaLogger.logger.isDebugEnabled()) {
            jtaLogger.logger.debugv("{0} - first pass", (Object)this._logName);
        }
        this._uids = new InputObjectState();
        try {
            if (!this._recoveryStore.allObjUids(this._recoveryManagerClass.type(), this._uids)) {
                jtaLogger.i18NLogger.warn_recovery_alluids();
            }
        }
        catch (ObjectStoreException e) {
            jtaLogger.i18NLogger.warn_recovery_objstoreerror(e);
        }
        catch (Exception e) {
            jtaLogger.i18NLogger.warn_recovery_periodicfirstpass(this._logName + ".periodicWorkFirstPass", e);
        }
        List<XAResource> resources = this.resourceInitiatedRecovery();
        resources.addAll(this.resourceInitiatedRecoveryForRecoveryHelpers());
        for (XAResource xaResource : resources) {
            try {
                this.xaRecoveryFirstPass(xaResource);
            }
            catch (Exception ex) {
                jtaLogger.i18NLogger.warn_recovery_getxaresource(ex);
            }
        }
        this.requireFirstPass = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void periodicWorkSecondPass() {
        if (jtaLogger.logger.isDebugEnabled()) {
            jtaLogger.logger.debugv("{0} - second pass", (Object)this._logName);
        }
        try {
            this.transactionInitiatedRecovery();
            if (jtaLogger.logger.isDebugEnabled()) {
                jtaLogger.logger.debug((Object)(this._logName + ".transactionInitiatedRecovery completed"));
            }
            this.bottomUpRecovery();
            if (jtaLogger.logger.isDebugEnabled()) {
                jtaLogger.logger.debug((Object)(this._logName + ".resourceInitiatedRecovery completed"));
            }
        }
        catch (Exception e) {
            jtaLogger.i18NLogger.warn_recovery_periodicsecondpass(this._logName + ".periodicWorkSecondPass", e);
        }
        this.clearAllFailures();
        XARecoveryModule xARecoveryModule = this;
        synchronized (xARecoveryModule) {
            this.requireFirstPass = true;
        }
    }

    public String id() {
        return "XARecoveryModule:" + this._recoveryManagerClass;
    }

    private XAResource getNewXAResource(Xid xid) {
        this.periodicWorkFirstPass();
        if (this._xidScans != null) {
            Enumeration<XAResource> keys = this._xidScans.keys();
            while (keys.hasMoreElements()) {
                XAResource theKey = keys.nextElement();
                RecoveryXids xids = this._xidScans.get(theKey);
                if (!xids.contains(xid)) continue;
                xids.remove(xid);
                return theKey;
            }
        }
        return null;
    }

    public XAResource getNewXAResource(XAResourceRecord xaResourceRecord) {
        return this.getNewXAResource(xaResourceRecord.getXid());
    }

    protected XARecoveryModule(XARecoveryResourceManager recoveryClass, String logName) {
        this._logName = logName;
        this._recoveryManagerClass = recoveryClass;
        if (this._recoveryManagerClass == null) {
            jtaLogger.i18NLogger.warn_recovery_constfail();
        }
        this._xaRecoverers = jtaPropertyManager.getJTAEnvironmentBean().getXaResourceRecoveries();
        this._xaResourceOrphanFilters = jtaPropertyManager.getJTAEnvironmentBean().getXaResourceOrphanFilters();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean transactionInitiatedRecovery() {
        Uid theUid = null;
        while (Uid.nullUid().notEquals(theUid)) {
            try {
                theUid = UidHelper.unpackFrom(this._uids);
                if (!theUid.notEquals(Uid.nullUid()) || this._recoveryStore.currentState(theUid, this._recoveryManagerClass.type()) == -1) continue;
                boolean problem = false;
                XARecoveryResource record = null;
                try {
                    record = this._recoveryManagerClass.getResource(theUid);
                    problem = true;
                    switch (record.recoverable()) {
                        case 12: {
                            int recoveryStatus;
                            if (jtaLogger.logger.isDebugEnabled()) {
                                jtaLogger.logger.debug((Object)("XARecovery attempting recovery of " + theUid));
                            }
                            if ((recoveryStatus = record.recover()) != 1) {
                                if (recoveryStatus == 3) {
                                    problem = false;
                                    jtaLogger.i18NLogger.info_recovery_recoverydelayed(theUid, Integer.toString(recoveryStatus));
                                    break;
                                }
                                jtaLogger.i18NLogger.warn_recovery_recoveryfailed(theUid, Integer.toString(recoveryStatus));
                                break;
                            }
                            problem = false;
                            break;
                        }
                        case 11: {
                            problem = false;
                            break;
                        }
                        default: {
                            if (!jtaLogger.logger.isDebugEnabled()) break;
                            jtaLogger.logger.debug((Object)("XARecovery " + theUid + " is non-recoverable"));
                            break;
                        }
                    }
                }
                catch (NullPointerException ex) {
                    problem = true;
                }
                catch (Throwable e) {
                    problem = true;
                    jtaLogger.i18NLogger.warn_recovery_recoveryerror(e);
                }
                if (!problem || record == null) continue;
                if (record.getXid() == null) {
                    jtaLogger.i18NLogger.warn_recovery_cannotadd();
                    continue;
                }
                this.addFailure(record.getXid(), record.get_uid());
            }
            catch (IOException e) {
                theUid = Uid.nullUid();
            }
            catch (Throwable e) {
                jtaLogger.i18NLogger.warn_recovery_unexpectedrecoveryerror(e);
                continue;
            }
            break;
        }
        return true;
    }

    private void bottomUpRecovery() {
        if (this._xidScans != null) {
            ArrayList<XAResource> resources = Collections.list(this._xidScans.keys());
            for (XAResource xaResource : resources) {
                try {
                    this.xaRecoverySecondPass(xaResource);
                }
                catch (Exception ex) {
                    jtaLogger.i18NLogger.warn_recovery_getxaresource(ex);
                }
            }
        }
        if (this._xidScans != null) {
            HashSet<XAResource> keys = new HashSet<XAResource>(this._xidScans.keySet());
            for (XAResource theKey : keys) {
                RecoveryXids recoveryXids = this._xidScans.get(theKey);
                if (!recoveryXids.isStale()) continue;
                this._xidScans.remove(theKey);
            }
        }
    }

    private final List<XAResource> resourceInitiatedRecovery() {
        ArrayList<XAResource> xaresources = new ArrayList<XAResource>();
        if (this._xaRecoverers.size() > 0) {
            for (int i = 0; i < this._xaRecoverers.size(); ++i) {
                try {
                    XAResourceRecovery ri = this._xaRecoverers.get(i);
                    while (ri.hasMoreResources()) {
                        xaresources.add(ri.getXAResource());
                    }
                    continue;
                }
                catch (Exception ex) {
                    jtaLogger.i18NLogger.warn_recovery_getxaresource(ex);
                }
            }
        }
        return xaresources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<XAResource> resourceInitiatedRecoveryForRecoveryHelpers() {
        ArrayList<XAResource> xaresources = new ArrayList<XAResource>();
        List<XAResourceRecoveryHelper> list2 = this._xaResourceRecoveryHelpers;
        synchronized (list2) {
            for (XAResourceRecoveryHelper xaResourceRecoveryHelper : this._xaResourceRecoveryHelpers) {
                try {
                    XAResource[] xaResources = xaResourceRecoveryHelper.getXAResources();
                    if (xaResources == null) continue;
                    for (XAResource xaResource : xaResources) {
                        xaresources.add(xaResource);
                    }
                }
                catch (Exception ex) {
                    jtaLogger.i18NLogger.warn_recovery_getxaresource(ex);
                }
            }
        }
        return xaresources;
    }

    private final void xaRecoveryFirstPass(XAResource xares) {
        if (jtaLogger.logger.isDebugEnabled()) {
            jtaLogger.logger.debug((Object)("xarecovery of " + xares));
        }
        Xid[] trans = null;
        try {
            trans = xares.recover(0x1000000);
            if (jtaLogger.logger.isDebugEnabled()) {
                jtaLogger.logger.debug((Object)("Found " + (trans != null ? trans.length : 0) + " xids in doubt"));
            }
        }
        catch (XAException e) {
            jtaLogger.i18NLogger.warn_recovery_xarecovery1(this._logName + ".xaRecovery", XAHelper.printXAErrorCode(e), e);
            try {
                xares.recover(0x800000);
            }
            catch (Exception e1) {
                // empty catch block
            }
            return;
        }
        RecoveryXids xidsToRecover = null;
        if (this._xidScans == null) {
            this._xidScans = new Hashtable();
        } else {
            this.refreshXidScansForEquivalentXAResourceImpl(xares, trans);
            xidsToRecover = this._xidScans.get(xares);
            if (xidsToRecover == null) {
                Enumeration<RecoveryXids> elements = this._xidScans.elements();
                boolean found = false;
                while (elements.hasMoreElements()) {
                    xidsToRecover = elements.nextElement();
                    if (!xidsToRecover.isSameRM(xares)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    xidsToRecover = null;
                }
            }
        }
        if (xidsToRecover == null) {
            xidsToRecover = new RecoveryXids(xares);
            this._xidScans.put(xares, xidsToRecover);
        }
        xidsToRecover.nextScan(trans);
    }

    private void xaRecoverySecondPass(XAResource xares) {
        block14: {
            RecoveryXids xidsToRecover = this._xidScans.get(xares);
            try {
                Xid[] xids = xidsToRecover.toRecover();
                if (xids == null) break block14;
                if (jtaLogger.logger.isDebugEnabled()) {
                    jtaLogger.logger.debug((Object)("Have " + xids.length + " Xids to recover on this pass."));
                }
                for (int j = 0; j < xids.length; ++j) {
                    boolean doForget = false;
                    Uid recordUid = null;
                    boolean foundTransaction = false;
                    while ((recordUid = this.previousFailure(xids[j])) != null || !foundTransaction) {
                        if (recordUid == null) {
                            doForget = this.handleOrphan(xares, xids[j]);
                        } else {
                            foundTransaction = true;
                            XARecoveryResource record = this._recoveryManagerClass.getResource(recordUid, xares);
                            int recoveryStatus = record.recover();
                            if (recoveryStatus != 1) {
                                jtaLogger.i18NLogger.warn_recovery_failedtorecover(this._logName + ".xaRecovery", Integer.toString(recoveryStatus));
                            }
                            this.removeFailure(record.getXid(), record.get_uid());
                        }
                        if (doForget) {
                            try {
                                xares.forget(xids[j]);
                            }
                            catch (Exception e) {
                                jtaLogger.i18NLogger.warn_recovery_forgetfailed(this._logName + ".xaRecovery", e);
                            }
                        }
                        if (recordUid != null) continue;
                    }
                }
            }
            catch (Exception e) {
                jtaLogger.i18NLogger.warn_recovery_generalrecoveryerror(this._logName + ".xaRecovery", e);
            }
        }
        try {
            if (xares != null) {
                xares.recover(0x800000);
            }
        }
        catch (XAException e) {
            jtaLogger.i18NLogger.warn_recovery_xarecovery1(this._logName + ".xaRecovery", XAHelper.printXAErrorCode(e), e);
        }
    }

    private boolean handleOrphan(XAResource xares, Xid xid) {
        XAResourceOrphanFilter.Vote votingOutcome = XAResourceOrphanFilter.Vote.LEAVE_ALONE;
        for (XAResourceOrphanFilter filter : this._xaResourceOrphanFilters) {
            XAResourceOrphanFilter.Vote vote = filter.checkXid(xid);
            if (jtaLogger.logger.isDebugEnabled()) {
                jtaLogger.logger.debug((Object)("XAResourceOrphanFilter " + filter.getClass().getName() + " voted " + (Object)((Object)vote)));
            }
            if (vote == XAResourceOrphanFilter.Vote.LEAVE_ALONE) {
                return false;
            }
            if (vote != XAResourceOrphanFilter.Vote.ROLLBACK) continue;
            votingOutcome = vote;
        }
        try {
            if (votingOutcome == XAResourceOrphanFilter.Vote.ROLLBACK) {
                jtaLogger.i18NLogger.info_recovery_rollingback(XAHelper.xidToString(xid));
                xares.rollback(xid);
            }
        }
        catch (XAException e1) {
            e1.printStackTrace();
            switch (e1.errorCode) {
                case -3: {
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 100: {
                    return true;
                }
            }
        }
        catch (Exception e2) {
            jtaLogger.i18NLogger.warn_recovery_xarecovery2(this._logName + ".xaRecovery", e2);
        }
        return false;
    }

    private void refreshXidScansForEquivalentXAResourceImpl(XAResource xares, Xid[] xids) {
        HashSet<XAResource> keys = new HashSet<XAResource>(this._xidScans.keySet());
        for (XAResource theKey : keys) {
            RecoveryXids recoveryXids = this._xidScans.get(theKey);
            if (!recoveryXids.updateIfEquivalentRM(xares, xids)) continue;
            this._xidScans.remove(theKey);
            this._xidScans.put(xares, recoveryXids);
        }
    }

    private final Uid previousFailure(Xid xid) {
        if (this._failures == null) {
            return null;
        }
        Enumeration e = this._failures.keys();
        while (e.hasMoreElements()) {
            Xid theXid = (Xid)e.nextElement();
            if (!XAHelper.sameXID(xid, theXid)) continue;
            Vector failureItem = (Vector)this._failures.get(theXid);
            Uid u = (Uid)failureItem.remove(0);
            if (failureItem.size() == 0) {
                this._failures.remove(theXid);
            }
            return u;
        }
        return null;
    }

    private void addFailure(Xid xid, Uid uid) {
        Vector<Uid> failureItem;
        if (this._failures == null) {
            this._failures = new Hashtable();
        }
        if ((failureItem = (Vector<Uid>)this._failures.get(xid)) == null) {
            failureItem = new Vector<Uid>();
            this._failures.put(xid, failureItem);
        }
        failureItem.addElement(uid);
    }

    private void removeFailure(Xid xid, Uid uid) {
        Vector failureItem = (Vector)this._failures.get(xid);
        if (failureItem != null) {
            failureItem.remove(uid);
            if (failureItem.size() == 0) {
                this._failures.remove(xid);
            }
        }
    }

    private void clearAllFailures() {
        if (this._failures != null) {
            this._failures.clear();
        }
    }
}

