/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;

public class SysPropertyActions {
    public static String getProperty(String name, String defaultValue) {
        String prop = System.getSecurityManager() == null ? SysProps.NON_PRIVILEDGED.getProperty(name, defaultValue) : SysProps.PRIVILEDGED.getProperty(name, defaultValue);
        return prop;
    }

    public static Properties getProperties() {
        if (System.getSecurityManager() == null) {
            return SysProps.NON_PRIVILEDGED.getProperties();
        }
        return SysProps.PRIVILEDGED.getProperties();
    }

    static interface SysProps {
        public static final SysProps NON_PRIVILEDGED = new SysProps(){

            @Override
            public String getProperty(String name, String defaultValue) {
                return System.getProperty(name, defaultValue);
            }

            @Override
            public Properties getProperties() {
                return System.getProperties();
            }
        };
        public static final SysProps PRIVILEDGED = new SysProps(){

            @Override
            public String getProperty(final String name, final String defaultValue) {
                PrivilegedAction<String> action = new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return System.getProperty(name, defaultValue);
                    }
                };
                return AccessController.doPrivileged(action);
            }

            @Override
            public Properties getProperties() {
                PrivilegedAction<Properties> action = new PrivilegedAction<Properties>(){

                    @Override
                    public Properties run() {
                        return System.getProperties();
                    }
                };
                return AccessController.doPrivileged(action);
            }
        };

        public String getProperty(String var1, String var2);

        public Properties getProperties();
    }
}

