/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.vfs30;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.jboss.osgi.vfs.VFSMessages;
import org.jboss.vfs.VirtualFile;

class VFSEntryPathsEnumeration
implements Enumeration<String> {
    private Iterator<String> paths;

    public VFSEntryPathsEnumeration(VirtualFile root, VirtualFile file) throws IOException {
        if (root == null) {
            throw VFSMessages.MESSAGES.illegalArgumentNull("root");
        }
        if (file == null) {
            throw VFSMessages.MESSAGES.illegalArgumentNull("file");
        }
        String rootPath = root.getPathName();
        ArrayList<String> paths = new ArrayList<String>();
        List children = file.getChildren();
        for (VirtualFile child : children) {
            String fixedPath = this.fixPath(rootPath, child);
            if (fixedPath == null) continue;
            paths.add(fixedPath);
        }
        this.paths = paths.iterator();
    }

    @Override
    public boolean hasMoreElements() {
        return this.paths.hasNext();
    }

    @Override
    public String nextElement() {
        return this.paths.next();
    }

    private String fixPath(String rootPath, VirtualFile file) {
        String result = file.getPathName();
        int length = rootPath.length();
        if (length != 0) {
            result = result.substring(length);
        }
        if (file.isDirectory() && !result.endsWith("/")) {
            result = result + "/";
        }
        if (result.startsWith("/")) {
            result = result.substring(1);
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }
}

