/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.delegates;

import java.util.List;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.ext.RuntimeDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheControlDelegate
implements RuntimeDelegate.HeaderDelegate<CacheControl> {
    public CacheControl fromString(String value) throws IllegalArgumentException {
        String[] directives;
        if (value == null) {
            throw new IllegalArgumentException("Cache-Control value is null");
        }
        CacheControl result = new CacheControl();
        for (String directive : directives = value.split(",")) {
            String lowercase;
            directive = directive.trim();
            String[] nv = directive.split("=");
            String name = nv[0].trim();
            String val = null;
            if (nv.length > 1) {
                val = nv[1].trim();
                if (val.startsWith("\"")) {
                    val = val.substring(1);
                }
                if (val.endsWith("\"")) {
                    val = val.substring(0, val.length() - 1);
                }
            }
            if ("no-cache".equals(lowercase = name.toLowerCase())) {
                result.setNoCache(true);
                if (val == null || "".equals(val)) continue;
                result.getNoCacheFields().add(val);
                continue;
            }
            if ("private".equals(lowercase)) {
                result.setPrivate(true);
                if (val == null || "".equals(val)) continue;
                result.getPrivateFields().add(val);
                continue;
            }
            if ("no-store".equals(lowercase)) {
                result.setNoStore(true);
                continue;
            }
            if ("max-age".equals(lowercase)) {
                if (val == null) {
                    throw new IllegalArgumentException("CacheControl max-age header does not have a value: " + value);
                }
                result.setMaxAge(Integer.valueOf(val).intValue());
                continue;
            }
            if ("s-maxage".equals(lowercase)) {
                if (val == null) {
                    throw new IllegalArgumentException("CacheControl s-maxage header does not have a value: " + value);
                }
                result.setSMaxAge(Integer.valueOf(val).intValue());
                continue;
            }
            if ("no-transform".equals(lowercase)) {
                result.setNoTransform(true);
                continue;
            }
            if ("must-revalidate".equals(lowercase)) {
                result.setMustRevalidate(true);
                continue;
            }
            if ("proxy-revalidate".equals(lowercase)) {
                result.setProxyRevalidate(true);
                continue;
            }
            result.setNoCache(true);
            if (val == null) {
                val = "";
            }
            result.getCacheExtension().put(name, val);
        }
        return result;
    }

    private static StringBuffer addDirective(String directive, StringBuffer buffer) {
        if (buffer.length() > 0) {
            buffer.append(", ");
        }
        buffer.append(directive);
        return buffer;
    }

    public String toString(CacheControl value) {
        List fields;
        StringBuffer buffer = new StringBuffer();
        if (!value.isPrivate()) {
            buffer.append("public");
        }
        if (value.isMustRevalidate()) {
            CacheControlDelegate.addDirective("must-revalidate", buffer);
        }
        if (value.isNoTransform()) {
            CacheControlDelegate.addDirective("no-transform", buffer);
        }
        if (value.isNoStore()) {
            CacheControlDelegate.addDirective("no-store", buffer);
        }
        if (value.isProxyRevalidate()) {
            CacheControlDelegate.addDirective("proxy-revalidate", buffer);
        }
        if (value.getSMaxAge() > -1) {
            CacheControlDelegate.addDirective("s-maxage", buffer).append("=").append(value.getSMaxAge());
        }
        if (value.getMaxAge() > -1) {
            CacheControlDelegate.addDirective("max-age", buffer).append("=").append(value.getMaxAge());
        }
        if (value.isNoCache()) {
            fields = value.getNoCacheFields();
            if (fields.size() < 1) {
                CacheControlDelegate.addDirective("no-cache", buffer);
            } else {
                for (String field : value.getNoCacheFields()) {
                    CacheControlDelegate.addDirective("no-cache", buffer).append("=\"").append(field).append("\"");
                }
            }
        }
        if (value.isPrivate()) {
            fields = value.getPrivateFields();
            if (fields.size() < 1) {
                CacheControlDelegate.addDirective("private", buffer);
            } else {
                for (String field : value.getPrivateFields()) {
                    CacheControlDelegate.addDirective("private", buffer).append("=\"").append(field).append("\"");
                }
            }
        }
        for (String key : value.getCacheExtension().keySet()) {
            String val = (String)value.getCacheExtension().get(key);
            CacheControlDelegate.addDirective(key, buffer);
            if (val == null || "".equals(val)) continue;
            buffer.append("=\"").append(val).append("\"");
        }
        return buffer.toString();
    }
}

