/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Locale;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.annotations.providers.img.ImageWriterParams;
import org.jboss.resteasy.core.LoggerCategories;
import org.jboss.resteasy.plugins.providers.AbstractEntityProvider;
import org.jboss.resteasy.plugins.providers.IIOImageProviderHelper;
import org.jboss.resteasy.util.FindAnnotation;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Consumes(value={"image/*"})
@Produces(value={"image/*"})
public class IIOImageProvider
extends AbstractEntityProvider<IIOImage> {
    private static final Logger logger = LoggerCategories.getProviderLogger();

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return IIOImage.class.equals(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IIOImage readFrom(Class<IIOImage> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        ImageReader reader = IIOImageProviderHelper.getImageReaderByMediaType(mediaType);
        try {
            IIOImage image;
            IIOImage iIOImage = image = IIOImageProviderHelper.readImage(entityStream, reader, 0);
            return iIOImage;
        }
        finally {
            reader.dispose();
        }
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return IIOImage.class.equals(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(IIOImage t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        ImageWriter writer = IIOImageProviderHelper.getImageWriterByMediaType(mediaType);
        ImageWriteParam param = mediaType.equals((Object)MediaType.valueOf((String)"image/jpeg")) ? new JPEGImageWriteParam(Locale.US) : writer.getDefaultWriteParam();
        ImageWriterParams writerParams = FindAnnotation.findAnnotation(annotations, ImageWriterParams.class);
        if (writerParams != null) {
            if (param.canWriteCompressed()) {
                param.setCompressionMode(writerParams.compressionMode());
                param.setCompressionQuality(writerParams.compressionQuality());
            }
        } else if (param.canWriteCompressed()) {
            param.setCompressionMode(2);
            param.setCompressionQuality(1.0f);
        }
        BufferedOutputStream buff = new BufferedOutputStream(entityStream, 2048);
        ImageOutputStream ios = ImageIO.createImageOutputStream(buff);
        try {
            writer.setOutput(ios);
            IIOImage img = new IIOImage(t.getRenderedImage(), null, null);
            writer.write(null, img, param);
        }
        finally {
            writer.dispose();
        }
    }
}

