/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.cache;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import javax.ws.rs.GET;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.cache.BrowserCache;
import org.jboss.resteasy.client.cache.CachedClientResponse;
import org.jboss.resteasy.client.core.BaseClientResponse;
import org.jboss.resteasy.core.interception.AcceptedByMethod;
import org.jboss.resteasy.core.interception.ClientExecutionContext;
import org.jboss.resteasy.core.interception.ClientExecutionInterceptor;
import org.jboss.resteasy.util.DateUtil;
import org.jboss.resteasy.util.ReadFromStream;
import org.jboss.resteasy.util.WeightedMediaType;

public class CacheInterceptor
implements ClientExecutionInterceptor,
AcceptedByMethod {
    protected BrowserCache cache;

    public CacheInterceptor(BrowserCache cache) {
        this.cache = cache;
    }

    public boolean accept(Class declaring, Method method) {
        if (declaring == null || method == null) {
            return true;
        }
        return method.isAnnotationPresent(GET.class);
    }

    public ClientResponse execute(ClientExecutionContext ctx) throws Exception {
        ClientRequest request = ctx.getRequest();
        if (!request.getHttpMethod().equals("GET")) {
            return ctx.proceed();
        }
        BrowserCache.Entry entry = this.getEntry(request);
        if (entry == null) {
            return this.cache(request, ctx.proceed());
        }
        if (entry.expired()) {
            BrowserCache.Header[] headers;
            this.cache.remove(request.getUri(), entry.getMediaType());
            for (BrowserCache.Header header : headers = entry.getValidationHeaders()) {
                request.header(header.getName(), header.getValue());
            }
            return this.handleExpired(ctx, request, entry);
        }
        return new CachedClientResponse(entry, request.getProviderFactory());
    }

    protected ClientResponse handleExpired(ClientExecutionContext ctx, ClientRequest request, BrowserCache.Entry entry) throws Exception {
        ClientResponse response = ctx.proceed();
        if (response.getStatus() == Response.Status.NOT_MODIFIED.getStatusCode()) {
            return this.updateOnNotModified(request, entry, (BaseClientResponse)response);
        }
        return this.cache(request, response);
    }

    private ClientResponse cache(ClientRequest request, ClientResponse response) throws Exception {
        if (response.getStatus() != 200) {
            return response;
        }
        return this.cacheIfPossible(request, (BaseClientResponse)response);
    }

    public ClientResponse updateOnNotModified(ClientRequest request, BrowserCache.Entry old, BaseClientResponse response) throws Exception {
        old.getHeaders().remove((Object)"Cache-Control");
        old.getHeaders().remove((Object)"Expires");
        old.getHeaders().remove((Object)"Last-Modified");
        String cc = (String)response.getHeaders().getFirst((Object)"Cache-Control");
        String exp = (String)response.getHeaders().getFirst((Object)"Expires");
        int expires = -1;
        if (cc != null) {
            CacheControl cacheControl = CacheControl.valueOf((String)cc);
            if (cacheControl.isNoCache()) {
                return new CachedClientResponse(old, request.getProviderFactory());
            }
            expires = cacheControl.getMaxAge();
        } else if (exp != null) {
            Date date = DateUtil.parseDate(exp);
            expires = (int)((date.getTime() - System.currentTimeMillis()) / 1000L);
        }
        if (cc != null) {
            old.getHeaders().putSingle((Object)"Cache-Control", (Object)cc);
        }
        if (exp != null) {
            old.getHeaders().putSingle((Object)"Cache-Control", (Object)exp);
        }
        String lastModified = (String)response.getHeaders().getFirst((Object)"Last-Modified");
        String etag = (String)response.getHeaders().getFirst((Object)"ETag");
        if (etag == null) {
            etag = (String)old.getHeaders().getFirst((Object)"ETag");
        } else {
            old.getHeaders().putSingle((Object)"ETag", (Object)etag);
        }
        if (lastModified != null) {
            old.getHeaders().putSingle((Object)"Last-Modified", (Object)lastModified);
        }
        if (etag == null && lastModified == null && cc == null && exp == null) {
            return new CachedClientResponse(old, request.getProviderFactory());
        }
        BrowserCache.Entry entry = this.cache.put(request.getUri(), old.getMediaType(), old.getHeaders(), old.getCached(), expires, etag, lastModified);
        return new CachedClientResponse(entry, request.getProviderFactory());
    }

    public ClientResponse cacheIfPossible(ClientRequest request, BaseClientResponse response) throws Exception {
        String cc = (String)response.getHeaders().getFirst((Object)"Cache-Control");
        String exp = (String)response.getHeaders().getFirst((Object)"Expires");
        int expires = -1;
        if (cc != null) {
            CacheControl cacheControl = CacheControl.valueOf((String)cc);
            if (cacheControl.isNoCache()) {
                return response;
            }
            expires = cacheControl.getMaxAge();
        } else if (exp != null) {
            Date date = DateUtil.parseDate(exp);
            expires = (int)((date.getTime() - System.currentTimeMillis()) / 1000L);
        }
        String lastModified = (String)response.getHeaders().getFirst((Object)"Last-Modified");
        String etag = (String)response.getHeaders().getFirst((Object)"ETag");
        String contentType = (String)response.getHeaders().getFirst((Object)"Content-Type");
        byte[] cached = ReadFromStream.readFromStream(1024, response.getInputStream());
        response.releaseConnection();
        BrowserCache.Entry entry = this.cache.put(request.getUri(), MediaType.valueOf((String)contentType), response.getHeaders(), cached, expires, etag, lastModified);
        return new CachedClientResponse(entry, request.getProviderFactory());
    }

    protected BrowserCache.Entry getEntry(ClientRequest request) throws Exception {
        String uri = request.getUri();
        BrowserCache.Entry entry = null;
        String acceptHeader = (String)request.getHeaders().getFirst((Object)"Accept");
        if (acceptHeader != null) {
            String[] split;
            ArrayList<WeightedMediaType> waccepts = new ArrayList<WeightedMediaType>();
            for (String accept : split = acceptHeader.split(",")) {
                waccepts.add(WeightedMediaType.valueOf(accept));
            }
            Collections.sort(waccepts);
            ArrayList<MediaType> accepts = new ArrayList<MediaType>();
            for (WeightedMediaType accept : waccepts) {
                accepts.add(new MediaType(accept.getType(), accept.getSubtype(), accept.getParameters()));
            }
            for (MediaType accept : accepts) {
                entry = this.cache.get(uri, accept);
                if (entry == null) continue;
                return entry;
            }
        } else {
            return this.cache.getAny(uri);
        }
        return null;
    }
}

