/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.annotations.Form;
import org.jboss.resteasy.annotations.Suspend;
import org.jboss.resteasy.core.ConstructorInjectorImpl;
import org.jboss.resteasy.core.ContextParameterInjector;
import org.jboss.resteasy.core.CookieParamInjector;
import org.jboss.resteasy.core.FormInjector;
import org.jboss.resteasy.core.FormParamInjector;
import org.jboss.resteasy.core.HeaderParamInjector;
import org.jboss.resteasy.core.MatrixParamInjector;
import org.jboss.resteasy.core.MessageBodyParameterInjector;
import org.jboss.resteasy.core.MethodInjectorImpl;
import org.jboss.resteasy.core.PathParamInjector;
import org.jboss.resteasy.core.PropertyInjectorImpl;
import org.jboss.resteasy.core.QueryParamInjector;
import org.jboss.resteasy.core.SuspendInjector;
import org.jboss.resteasy.core.ValueInjector;
import org.jboss.resteasy.spi.ConstructorInjector;
import org.jboss.resteasy.spi.InjectorFactory;
import org.jboss.resteasy.spi.MethodInjector;
import org.jboss.resteasy.spi.PropertyInjector;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.FindAnnotation;

public class InjectorFactoryImpl
implements InjectorFactory {
    private ResteasyProviderFactory factory;

    public InjectorFactoryImpl(ResteasyProviderFactory factory) {
        this.factory = factory;
    }

    public ConstructorInjector createConstructor(Constructor constructor) {
        return new ConstructorInjectorImpl(constructor, this.factory);
    }

    public PropertyInjector createPropertyInjector(Class resourceClass) {
        return new PropertyInjectorImpl(resourceClass, this.factory);
    }

    public MethodInjector createMethodInjector(Class root, Method method) {
        return new MethodInjectorImpl(root, method, this.factory);
    }

    public static ValueInjector getParameterExtractor(Class injectTargetClass, AccessibleObject injectTarget, Class type, Type genericType, Annotation[] annotations, ResteasyProviderFactory providerFactory) {
        QueryParam query;
        DefaultValue defaultValue = FindAnnotation.findAnnotation(annotations, DefaultValue.class);
        boolean encode = FindAnnotation.findAnnotation(annotations, Encoded.class) != null || injectTarget.isAnnotationPresent(Encoded.class) || type.isAnnotationPresent(Encoded.class);
        String defaultVal = null;
        if (defaultValue != null) {
            defaultVal = defaultValue.value();
        }
        if ((query = FindAnnotation.findAnnotation(annotations, QueryParam.class)) != null) {
            return new QueryParamInjector(type, genericType, injectTarget, query.value(), defaultVal, encode, providerFactory);
        }
        HeaderParam header = FindAnnotation.findAnnotation(annotations, HeaderParam.class);
        if (header != null) {
            return new HeaderParamInjector(type, genericType, injectTarget, header.value(), defaultVal, providerFactory);
        }
        FormParam formParam = FindAnnotation.findAnnotation(annotations, FormParam.class);
        if (formParam != null) {
            return new FormParamInjector(type, genericType, injectTarget, formParam.value(), defaultVal, providerFactory);
        }
        CookieParam cookie = FindAnnotation.findAnnotation(annotations, CookieParam.class);
        if (cookie != null) {
            return new CookieParamInjector(type, genericType, injectTarget, cookie.value(), defaultVal, providerFactory);
        }
        PathParam uriParam = FindAnnotation.findAnnotation(annotations, PathParam.class);
        if (uriParam != null) {
            return new PathParamInjector(type, genericType, injectTarget, uriParam.value(), defaultVal, encode, providerFactory);
        }
        Form form = FindAnnotation.findAnnotation(annotations, Form.class);
        if (form != null) {
            return new FormInjector(type, providerFactory);
        }
        MatrixParam matrix = FindAnnotation.findAnnotation(annotations, MatrixParam.class);
        if (matrix != null) {
            return new MatrixParamInjector(type, genericType, injectTarget, matrix.value(), defaultVal, providerFactory);
        }
        Suspend suspend = FindAnnotation.findAnnotation(annotations, Suspend.class);
        if (suspend != null) {
            return new SuspendInjector(suspend, type);
        }
        if (FindAnnotation.findAnnotation(annotations, Context.class) != null) {
            return new ContextParameterInjector(type, providerFactory);
        }
        return new MessageBodyParameterInjector(injectTargetClass, injectTarget, type, genericType, annotations, providerFactory);
    }
}

