/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.interception;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.jboss.resteasy.core.PropertyInjectorImpl;
import org.jboss.resteasy.core.interception.AcceptedByMethod;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorRegistry<T> {
    protected ResteasyProviderFactory providerFactory;
    protected Class<T> intf;
    protected List<InterceptorFactory> interceptors = new ArrayList<InterceptorFactory>();

    public InterceptorRegistry(Class<T> intf, ResteasyProviderFactory providerFactory) {
        this.providerFactory = providerFactory;
        this.intf = intf;
    }

    public T[] bind(Class declaring, AccessibleObject target) {
        List<Object> list = this.bindForList(declaring, target);
        return list.toArray((Object[])Array.newInstance(this.intf, list.size()));
    }

    public List<T> bindForList(Class declaring, AccessibleObject target) {
        ArrayList list = new ArrayList();
        for (InterceptorFactory factory : this.interceptors) {
            Object interceptor = factory.createInterceptor();
            if (interceptor instanceof AcceptedByMethod) {
                AcceptedByMethod accepted;
                if (target == null || !(target instanceof Method) || !(accepted = (AcceptedByMethod)interceptor).accept(declaring, (Method)target)) continue;
                this.addNewInterceptor(list, interceptor);
                continue;
            }
            this.addNewInterceptor(list, interceptor);
        }
        return list;
    }

    protected void addNewInterceptor(List<T> list, Object interceptor) {
        PropertyInjectorImpl injector = new PropertyInjectorImpl(interceptor.getClass(), this.providerFactory);
        injector.inject(interceptor);
        list.add(interceptor);
    }

    public void register(Class clazz) {
        this.interceptors.add(new PerMethodInterceptorFactory(clazz));
    }

    public void register(T interceptor) {
        this.interceptors.add(new SingletonInterceptorFactory(interceptor));
    }

    public void registerFirst(Class clazz) {
        this.interceptors.add(0, new PerMethodInterceptorFactory(clazz));
    }

    public void registerFirst(T interceptor) {
        this.interceptors.add(0, new SingletonInterceptorFactory(interceptor));
    }

    protected static class PerMethodInterceptorFactory
    implements InterceptorFactory {
        private Class clazz;

        public PerMethodInterceptorFactory(Class clazz) {
            this.clazz = clazz;
        }

        public Object createInterceptor() {
            try {
                return this.clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected static class SingletonInterceptorFactory
    implements InterceptorFactory {
        private Object target;

        public SingletonInterceptorFactory(Object target) {
            this.target = target;
        }

        public Object createInterceptor() {
            return this.target;
        }
    }

    protected static interface InterceptorFactory {
        public Object createInterceptor();
    }
}

