/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.util;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QualifiedStringHeader {
    private String value;
    private Map<String, String> parameters = new HashMap<String, String>();
    private double q = 1.0;

    protected QualifiedStringHeader() {
    }

    public QualifiedStringHeader(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public double getQ() {
        return this.q;
    }

    public static QualifiedStringHeader parse(String value) {
        QualifiedStringHeader header = new QualifiedStringHeader();
        int idx = value.indexOf(";");
        if (idx < 0) {
            header.value = value;
            header.q = 1.0;
        } else {
            String[] array;
            header.value = value.substring(0, idx);
            String params = value.substring(idx + 1);
            if (params.startsWith(";")) {
                params = params.substring(1);
            }
            for (String param : array = params.split(";")) {
                int pidx = param.indexOf("=");
                String name = param.substring(0, pidx);
                String val = param.substring(pidx + 1);
                if (name.equals("q")) {
                    header.q = Double.valueOf(val);
                    continue;
                }
                header.parameters.put(name, val);
            }
        }
        return header;
    }

    public boolean equals(Object o) {
        Map<String, String> params2;
        if (this == o) {
            return true;
        }
        if (!(o instanceof QualifiedStringHeader)) {
            return false;
        }
        QualifiedStringHeader comp = (QualifiedStringHeader)o;
        if (!this.value.equals(comp.value)) {
            return false;
        }
        Map<String, String> params1 = this.getParameters();
        if (params1 == (params2 = comp.getParameters())) {
            return true;
        }
        if (params1 == null || params2 == null) {
            return false;
        }
        if (params1.size() == 0 && params2.size() == 0) {
            return true;
        }
        int numParams1 = params1.size();
        if (params1.containsKey("q")) {
            --numParams1;
        }
        int numParams2 = params2.size();
        if (params2.containsKey("q")) {
            --numParams2;
        }
        if (numParams1 != numParams2) {
            return false;
        }
        if (numParams1 == 0) {
            return true;
        }
        for (Map.Entry<String, String> entry : params1.entrySet()) {
            String value2;
            String value;
            String key = entry.getKey();
            if (key.equals("q") || (value = entry.getValue()) == (value2 = params2.get(key))) continue;
            if (value == null || value2 == null) {
                return false;
            }
            if (value.equals(value2)) continue;
            return false;
        }
        return true;
    }

    public int compareWeight(QualifiedStringHeader header) {
        if (this.q == header.q) {
            return 0;
        }
        if (this.q < header.q) {
            return 1;
        }
        return -1;
    }
}

