/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.resteasy.core.ValueInjector;
import org.jboss.resteasy.spi.ApplicationException;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.InternalServerErrorException;
import org.jboss.resteasy.spi.PropertyInjector;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.metadata.FieldParameter;
import org.jboss.resteasy.spi.metadata.Parameter;
import org.jboss.resteasy.spi.metadata.ResourceClass;
import org.jboss.resteasy.spi.metadata.SetterParameter;

public class ResourcePropertyInjector
implements PropertyInjector {
    protected List<FieldInjector> fields = new ArrayList<FieldInjector>();
    protected List<SetterInjector> setters = new ArrayList<SetterInjector>();
    protected ResourceClass resourceClass;
    protected ResteasyProviderFactory factory;

    public ResourcePropertyInjector(ResourceClass resourceClass, ResteasyProviderFactory factory) {
        ValueInjector injector;
        this.resourceClass = resourceClass;
        this.factory = factory;
        for (FieldParameter fieldParameter : resourceClass.getFields()) {
            System.out.println("class: " + resourceClass);
            System.out.println("field: " + fieldParameter.getParamName());
            injector = factory.getInjectorFactory().createParameterExtractor(fieldParameter, factory);
            if (injector == null) continue;
            this.fields.add(new FieldInjector(fieldParameter, injector));
        }
        for (Parameter parameter : resourceClass.getSetters()) {
            injector = factory.getInjectorFactory().createParameterExtractor(parameter, factory);
            if (injector == null) continue;
            this.setters.add(new SetterInjector((SetterParameter)parameter, injector));
        }
    }

    @Override
    public void inject(HttpRequest request, HttpResponse response, Object target) throws Failure {
        for (FieldInjector fieldInjector : this.fields) {
            try {
                System.out.println("injecting field: " + fieldInjector.param.getField().getName());
                fieldInjector.param.getField().set(target, fieldInjector.injector.inject(request, response));
            }
            catch (IllegalAccessException e) {
                throw new InternalServerErrorException(e);
            }
        }
        for (SetterInjector setterInjector : this.setters) {
            try {
                setterInjector.param.getSetter().invoke(target, setterInjector.injector.inject(request, response));
            }
            catch (IllegalAccessException e) {
                throw new InternalServerErrorException(e);
            }
            catch (InvocationTargetException e) {
                throw new ApplicationException(e.getCause());
            }
        }
    }

    @Override
    public void inject(Object target) {
        for (FieldInjector fieldInjector : this.fields) {
            try {
                fieldInjector.param.getField().set(target, fieldInjector.injector.inject());
            }
            catch (IllegalAccessException e) {
                throw new InternalServerErrorException(e);
            }
        }
        for (SetterInjector setterInjector : this.setters) {
            try {
                setterInjector.param.getSetter().invoke(target, setterInjector.injector.inject());
            }
            catch (IllegalAccessException e) {
                throw new InternalServerErrorException(e);
            }
            catch (InvocationTargetException e) {
                throw new ApplicationException(e.getCause());
            }
        }
    }

    private static class SetterInjector {
        public SetterParameter param;
        public ValueInjector injector;

        private SetterInjector(SetterParameter param, ValueInjector injector) {
            this.param = param;
            this.injector = injector;
        }
    }

    private static class FieldInjector {
        public FieldParameter param;
        public ValueInjector injector;

        private FieldInjector(FieldParameter param, ValueInjector injector) {
            this.param = param;
            this.injector = injector;
        }
    }
}

