/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.exception.control;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import org.jboss.seam.exception.control.ExceptionStackItem;

public class ExceptionStack
implements Serializable {
    private static final long serialVersionUID = 5988683320170873619L;
    private boolean root;
    private boolean last;
    private int initialStackSize;
    private Throwable next;
    private Collection<ExceptionStackItem> remaining;
    private Deque<ExceptionStackItem> exceptionStackItems;
    private Deque<ExceptionStackItem> origExceptionStackItems;
    private Collection<Throwable> causes;
    private Throwable current;

    public ExceptionStack() {
    }

    public ExceptionStack(Throwable exception) {
        if (exception == null) {
            throw new IllegalArgumentException("exception must not be null");
        }
        Throwable e = exception;
        this.exceptionStackItems = new ArrayDeque<ExceptionStackItem>();
        do {
            this.exceptionStackItems.addFirst(new ExceptionStackItem(e));
            if (!(e instanceof SQLException)) continue;
            SQLException sqlException = (SQLException)e;
            while (sqlException.getNextException() != null) {
                sqlException = sqlException.getNextException();
                this.exceptionStackItems.addFirst(new ExceptionStackItem(sqlException));
            }
        } while ((e = e.getCause()) != null);
        this.initialStackSize = this.exceptionStackItems.size();
        this.causes = this.createThrowableCollectionFrom(this.exceptionStackItems);
        this.origExceptionStackItems = new ArrayDeque<ExceptionStackItem>(this.exceptionStackItems);
        this.init();
    }

    @Deprecated
    public ExceptionStack(Collection<Throwable> causeChainElements, int currentElementIndex) {
        if (causeChainElements == null || causeChainElements.size() == 0) {
            throw new IllegalArgumentException("Null or empty collection of causeChainElements is not valid");
        }
        if (currentElementIndex >= causeChainElements.size()) {
            throw new IllegalArgumentException("currentElementIndex must be less than or equals to causeChainElements.size()");
        }
        this.exceptionStackItems = new ArrayDeque<ExceptionStackItem>(this.createExceptionStackCollectionFrom(causeChainElements));
        this.causes = Collections.unmodifiableCollection(causeChainElements);
        this.origExceptionStackItems = new ArrayDeque<ExceptionStackItem>(this.exceptionStackItems);
        this.init();
    }

    private void init() {
        boolean bl = this.root = this.exceptionStackItems.size() == this.initialStackSize;
        if (!this.exceptionStackItems.isEmpty()) {
            this.current = this.exceptionStackItems.removeFirst().getThrowable();
            this.remaining = Collections.unmodifiableCollection(this.exceptionStackItems);
        } else {
            this.remaining = Collections.emptyList();
            this.current = null;
        }
        this.last = this.remaining.isEmpty();
        this.next = this.last ? null : this.exceptionStackItems.peekFirst().getThrowable();
    }

    private Collection<ExceptionStackItem> createExceptionStackCollectionFrom(Collection<Throwable> throwables) {
        ArrayDeque<ExceptionStackItem> returningCollection = new ArrayDeque<ExceptionStackItem>(throwables.size());
        for (Throwable t : throwables) {
            returningCollection.addFirst(new ExceptionStackItem(t));
        }
        return returningCollection;
    }

    private Collection<Throwable> createThrowableCollectionFrom(Collection<ExceptionStackItem> exceptionStackItems) {
        ArrayDeque<Throwable> returningCollection = new ArrayDeque<Throwable>(exceptionStackItems.size() + 1);
        for (ExceptionStackItem item : exceptionStackItems) {
            returningCollection.addFirst(item.getThrowable());
        }
        return returningCollection;
    }

    public Collection<Throwable> getCauseElements() {
        return Collections.unmodifiableCollection(this.causes);
    }

    public boolean isLast() {
        return this.last;
    }

    public Throwable getNext() {
        return this.next;
    }

    public Collection<Throwable> getRemaining() {
        return Collections.unmodifiableCollection(this.createThrowableCollectionFrom(this.remaining));
    }

    public boolean isRoot() {
        return this.root;
    }

    public Throwable getCurrent() {
        return this.current;
    }

    public void setCauseElements(Collection<Throwable> elements) {
        this.exceptionStackItems = new ArrayDeque<ExceptionStackItem>(this.createExceptionStackCollectionFrom(elements));
        this.init();
    }

    public Deque<ExceptionStackItem> getOrigExceptionStackItems() {
        return new ArrayDeque<ExceptionStackItem>(this.origExceptionStackItems);
    }

    protected void dropCause() {
        this.init();
    }
}

