/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.common.internal.util.logging;

import com.arjuna.common.internal.util.logging.AbstractLogImpl;
import com.arjuna.common.internal.util.logging.AbstractLogInterface;
import com.arjuna.common.internal.util.logging.DefaultLog;
import com.arjuna.common.internal.util.logging.LogInterface;
import com.arjuna.common.internal.util.logging.commonPropertyManager;
import com.arjuna.common.util.logging.Logi18n;

public class LogImpl
extends AbstractLogImpl
implements Logi18n {
    private LogInterface m_logInterface = null;
    private DefaultLog m_defaultLog = null;
    private boolean defaultLogSet = false;

    public LogImpl(LogInterface logInterface) {
        super(logInterface);
        this.m_logInterface = logInterface;
        this.setupDefaultLog("default");
    }

    public LogImpl(LogInterface logInterface, String resBundle) {
        super((AbstractLogInterface)logInterface, resBundle);
        this.m_logInterface = logInterface;
        this.setupDefaultLog(resBundle);
    }

    public LogImpl(LogInterface logInterface, String[] resBundles) {
        super((AbstractLogInterface)logInterface, resBundles);
        this.m_logInterface = logInterface;
        this.setupDefaultLog(resBundles[0]);
    }

    private void setupDefaultLog(String name) {
        String defaultLog = "false";
        try {
            defaultLog = commonPropertyManager.propertyManager.getProperty("com.arjuna.common.util.logging.default", null);
            if (defaultLog == null) {
                defaultLog = System.getProperty("com.arjuna.common.util.logging.default", "false");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (defaultLog.equals("true")) {
            this.m_defaultLog = new DefaultLog(name);
            this.defaultLogSet = true;
        }
    }

    public boolean isDebugEnabled() {
        if (this.defaultLogSet) {
            return this.m_logInterface.isDebugEnabled() || this.m_defaultLog.isDebugEnabled();
        }
        return this.m_logInterface.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        if (this.defaultLogSet) {
            return this.m_logInterface.isInfoEnabled() || this.m_defaultLog.isInfoEnabled();
        }
        return this.m_logInterface.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        if (this.defaultLogSet) {
            return this.m_logInterface.isWarnEnabled() || this.m_defaultLog.isWarnEnabled();
        }
        return this.m_logInterface.isWarnEnabled();
    }

    public boolean isErrorEnabled() {
        if (this.defaultLogSet) {
            return this.m_logInterface.isErrorEnabled() || this.m_defaultLog.isErrorEnabled();
        }
        return this.m_logInterface.isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        if (this.defaultLogSet) {
            return this.m_logInterface.isFatalEnabled() || this.m_defaultLog.isFatalEnabled();
        }
        return this.m_logInterface.isFatalEnabled();
    }

    public void debug(String key) {
        if (!this.isDebugEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key);
        this.m_logInterface.debug(message);
        if (this.defaultLogSet) {
            this.m_defaultLog.debug(message);
        }
    }

    public void debug(Throwable throwable) {
        if (!this.isDebugEnabled()) {
            return;
        }
        String message = throwable.getLocalizedMessage();
        this.m_logInterface.debug(message, throwable);
        if (this.defaultLogSet) {
            this.m_defaultLog.debug(message, throwable);
        }
    }

    public void debug(String key, Throwable throwable) {
        if (!this.isDebugEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key);
        this.m_logInterface.debug(message, throwable);
        if (this.defaultLogSet) {
            this.m_defaultLog.debug(message, throwable);
        }
    }

    public void debug(String key, Object[] params) {
        if (!this.isDebugEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key, params);
        this.m_logInterface.debug(message);
        if (this.defaultLogSet) {
            this.m_defaultLog.debug(message);
        }
    }

    public void debug(String key, Object[] params, Throwable throwable) {
        if (!this.isDebugEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key, params);
        this.m_logInterface.debug(message, throwable);
        if (this.defaultLogSet) {
            this.m_defaultLog.debug(message, throwable);
        }
    }

    public void info(String key) {
        if (!this.isInfoEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key);
        this.m_logInterface.info(message);
        if (this.defaultLogSet) {
            this.m_defaultLog.info(message);
        }
    }

    public void info(Throwable throwable) {
        if (!this.isInfoEnabled()) {
            return;
        }
        String message = throwable.getLocalizedMessage();
        this.m_logInterface.info(message, throwable);
        if (this.defaultLogSet) {
            this.m_defaultLog.info(message, throwable);
        }
    }

    public void info(String key, Throwable throwable) {
        if (!this.isInfoEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key);
        this.m_logInterface.info(message, throwable);
        if (this.defaultLogSet) {
            this.m_defaultLog.info(message, throwable);
        }
    }

    public void info(String key, Object[] params) {
        if (!this.isInfoEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key, params);
        this.m_logInterface.info(message);
        if (this.defaultLogSet) {
            this.m_defaultLog.info(message);
        }
    }

    public void info(String key, Object[] params, Throwable throwable) {
        if (!this.isInfoEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key, params);
        this.m_logInterface.info(message, throwable);
        if (this.defaultLogSet) {
            this.m_defaultLog.info(message, throwable);
        }
    }

    public void warn(String key) {
        if (!this.isWarnEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key);
        this.m_logInterface.warn(message);
        if (this.defaultLogSet) {
            this.m_defaultLog.warn(message);
        }
    }

    public void warn(Throwable throwable) {
        if (!this.isWarnEnabled()) {
            return;
        }
        String message = throwable.getLocalizedMessage();
        this.m_logInterface.warn(message, throwable);
        if (this.defaultLogSet) {
            this.m_defaultLog.warn(message, throwable);
        }
    }

    public void warn(String key, Throwable throwable) {
        if (!this.isWarnEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key);
        this.m_logInterface.warn(message, throwable);
        if (this.defaultLogSet) {
            this.m_defaultLog.warn(message, throwable);
        }
    }

    public void warn(String key, Object[] params) {
        if (!this.isWarnEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key, params);
        this.m_logInterface.warn(message);
        if (this.defaultLogSet) {
            this.m_defaultLog.warn(message);
        }
    }

    public void warn(String key, Object[] params, Throwable throwable) {
        if (!this.isWarnEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key, params);
        this.m_logInterface.warn(message, throwable);
        if (this.defaultLogSet) {
            this.m_defaultLog.warn(message, throwable);
        }
    }

    public void error(String key) {
        if (!this.isErrorEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key);
        this.m_logInterface.error(message);
        if (this.defaultLogSet) {
            this.m_defaultLog.error(message);
        }
    }

    public void error(Throwable throwable) {
        if (!this.isErrorEnabled()) {
            return;
        }
        String message = throwable.getLocalizedMessage();
        this.m_logInterface.error(message, throwable);
        if (this.defaultLogSet) {
            this.m_defaultLog.error(message, throwable);
        }
    }

    public void error(String key, Throwable throwable) {
        if (!this.isErrorEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key);
        this.m_logInterface.error(message, throwable);
        if (this.defaultLogSet) {
            this.m_defaultLog.error(message, throwable);
        }
    }

    public void error(String key, Object[] params) {
        if (!this.isErrorEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key, params);
        this.m_logInterface.error(message);
        if (this.defaultLogSet) {
            this.m_defaultLog.error(message);
        }
    }

    public void error(String key, Object[] params, Throwable throwable) {
        if (!this.isErrorEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key, params);
        this.m_logInterface.error(message, throwable);
        if (this.defaultLogSet) {
            this.m_defaultLog.error(message, throwable);
        }
    }

    public void fatal(String key) {
        if (!this.isFatalEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key);
        this.m_logInterface.fatal(message);
        if (this.defaultLogSet) {
            this.m_defaultLog.fatal(message);
        }
    }

    public void fatal(Throwable throwable) {
        if (!this.isFatalEnabled()) {
            return;
        }
        String message = throwable.getLocalizedMessage();
        this.m_logInterface.fatal(message, throwable);
        if (this.defaultLogSet) {
            this.m_defaultLog.fatal(message, throwable);
        }
    }

    public void fatal(String key, Throwable throwable) {
        if (!this.isFatalEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key);
        this.m_logInterface.fatal(message, throwable);
        if (this.defaultLogSet) {
            this.m_defaultLog.fatal(message, throwable);
        }
    }

    public void fatal(String key, Object[] params) {
        if (!this.isFatalEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key, params);
        this.m_logInterface.fatal(message);
        if (this.defaultLogSet) {
            this.m_defaultLog.fatal(message);
        }
    }

    public void fatal(String key, Object[] params, Throwable throwable) {
        if (!this.isFatalEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(key, params);
        this.m_logInterface.fatal(message, throwable);
        if (this.defaultLogSet) {
            this.m_defaultLog.fatal(message, throwable);
        }
    }

    public void debugb(String baseName, String key) {
        if (!this.isDebugEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(baseName, key);
        this.m_logInterface.debug(message);
        if (this.defaultLogSet) {
            this.m_defaultLog.debug(message);
        }
    }

    public void debugb(String baseName, String key, Throwable throwable) {
        if (!this.isDebugEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(baseName, key);
        this.m_logInterface.debug(message, throwable);
        if (this.defaultLogSet) {
            this.m_defaultLog.debug(message, throwable);
        }
    }

    public void debugb(String baseName, String key, Object[] params) {
        if (!this.isDebugEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(baseName, key, params);
        this.m_logInterface.debug(message);
        if (this.defaultLogSet) {
            this.m_defaultLog.debug(message);
        }
    }

    public void debugb(String baseName, String key, Object[] params, Throwable throwable) {
        if (!this.isDebugEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(baseName, key, params);
        this.m_logInterface.debug(message, throwable);
        if (this.defaultLogSet) {
            this.m_defaultLog.debug(message, throwable);
        }
    }

    public void infob(String baseName, String key) {
        if (!this.isInfoEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(baseName, key);
        this.m_logInterface.info(message);
        if (this.defaultLogSet) {
            this.m_defaultLog.info(message);
        }
    }

    public void infob(String baseName, String key, Throwable throwable) {
        if (!this.isInfoEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(baseName, key);
        this.m_logInterface.info(message, throwable);
        if (this.defaultLogSet) {
            this.m_defaultLog.info(message, throwable);
        }
    }

    public void infob(String baseName, String key, Object[] params) {
        if (!this.isInfoEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(baseName, key, params);
        this.m_logInterface.info(message);
        if (this.defaultLogSet) {
            this.m_defaultLog.info(message);
        }
    }

    public void infob(String baseName, String key, Object[] params, Throwable throwable) {
        if (!this.isInfoEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(baseName, key, params);
        this.m_logInterface.info(message, throwable);
        if (this.defaultLogSet) {
            this.m_defaultLog.info(message, throwable);
        }
    }

    public void warnb(String baseName, String key) {
        if (!this.isWarnEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(baseName, key);
        this.m_logInterface.warn(message);
        if (this.defaultLogSet) {
            this.m_defaultLog.warn(message);
        }
    }

    public void warnb(String baseName, String key, Throwable throwable) {
        if (!this.isWarnEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(baseName, key);
        this.m_logInterface.warn(message, throwable);
        if (this.defaultLogSet) {
            this.m_defaultLog.warn(message, throwable);
        }
    }

    public void warnb(String baseName, String key, Object[] params) {
        if (!this.isWarnEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(baseName, key, params);
        this.m_logInterface.warn(message);
        if (this.defaultLogSet) {
            this.m_defaultLog.warn(message);
        }
    }

    public void warnb(String baseName, String key, Object[] params, Throwable throwable) {
        if (!this.isWarnEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(baseName, key, params);
        this.m_logInterface.warn(message, throwable);
        if (this.defaultLogSet) {
            this.m_defaultLog.warn(message, throwable);
        }
    }

    public void errorb(String baseName, String key) {
        if (!this.isErrorEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(baseName, key);
        this.m_logInterface.error(message);
        if (this.defaultLogSet) {
            this.m_defaultLog.error(message);
        }
    }

    public void errorb(String baseName, String key, Throwable throwable) {
        if (!this.isErrorEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(baseName, key);
        this.m_logInterface.error(message, throwable);
        if (this.defaultLogSet) {
            this.m_defaultLog.error(message, throwable);
        }
    }

    public void errorb(String baseName, String key, Object[] params) {
        if (!this.isErrorEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(baseName, key, params);
        this.m_logInterface.error(message);
        if (this.defaultLogSet) {
            this.m_defaultLog.error(message);
        }
    }

    public void errorb(String baseName, String key, Object[] params, Throwable throwable) {
        if (!this.isErrorEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(baseName, key, params);
        this.m_logInterface.error(message, throwable);
        if (this.defaultLogSet) {
            this.m_defaultLog.error(message, throwable);
        }
    }

    public void fatalb(String baseName, String key) {
        if (!this.isFatalEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(baseName, key);
        this.m_logInterface.fatal(message);
        if (this.defaultLogSet) {
            this.m_defaultLog.fatal(message);
        }
    }

    public void fatalb(String baseName, String key, Throwable throwable) {
        if (!this.isFatalEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(baseName, key);
        this.m_logInterface.fatal(message, throwable);
        if (this.defaultLogSet) {
            this.m_defaultLog.fatal(message, throwable);
        }
    }

    public void fatalb(String baseName, String key, Object[] params) {
        if (!this.isFatalEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(baseName, key, params);
        this.m_logInterface.fatal(message);
        if (this.defaultLogSet) {
            this.m_defaultLog.fatal(message);
        }
    }

    public void fatalb(String baseName, String key, Object[] params, Throwable throwable) {
        if (!this.isFatalEnabled()) {
            return;
        }
        String message = this.evalResourceBundle(baseName, key, params);
        this.m_logInterface.fatal(message, throwable);
        if (this.defaultLogSet) {
            this.m_defaultLog.fatal(message, throwable);
        }
    }

    private String evalResourceBundle(String key) {
        return this.getString(key);
    }

    private String evalResourceBundle(String key, Object[] params) {
        return this.getString(key, params);
    }

    private String evalResourceBundle(String resBundle, String key) {
        return this.getString(resBundle, key);
    }

    private String evalResourceBundle(String resBundle, String key, Object[] params) {
        return this.getString(resBundle, key, params);
    }
}

