/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.microcontainer.beans;

import java.util.List;
import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.AdviceBinding;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.microcontainer.beans.Binding;
import org.jboss.aop.microcontainer.beans.BindingEntry;
import org.jboss.logging.Logger;
import org.jboss.util.id.GUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AspectBinding
implements Binding {
    private static final Logger log = Logger.getLogger(AspectBinding.class);
    protected AspectManager manager;
    protected String name = GUID.asString();
    protected String pointcut;
    protected List<BindingEntry> advices;
    protected String cflow;

    public AspectManager getManager() {
        return this.manager;
    }

    public void setManager(AspectManager manager) {
        this.manager = manager;
    }

    public String getCflow() {
        return this.cflow;
    }

    public void setCflow(String cflow) {
        this.cflow = cflow;
    }

    public String getPointcut() {
        return this.pointcut;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPointcut(String pointcut) {
        this.pointcut = pointcut;
    }

    public List<BindingEntry> getAdvices() {
        return this.advices;
    }

    public void setAdvices(List<BindingEntry> advices) {
        this.advices = advices;
    }

    public void start() throws Exception {
        if (this.pointcut == null) {
            throw new IllegalArgumentException("Null pointcut");
        }
        if (this.manager == null) {
            throw new IllegalArgumentException("Null manager");
        }
        AdviceBinding binding = new AdviceBinding(this.name, this.pointcut, this.cflow);
        if (this.advices != null) {
            for (BindingEntry entry : this.advices) {
                InterceptorFactory[] factories;
                entry.start();
                for (InterceptorFactory ifac : factories = entry.getInterceptorFactories()) {
                    binding.addInterceptorFactory(ifac);
                }
            }
        }
        this.manager.addBinding(binding);
        log.debug("Bound binding " + this.name);
    }

    public void stop() throws Exception {
        this.manager.removeBinding(this.name);
        if (this.advices != null) {
            for (BindingEntry entry : this.advices) {
                entry.stop();
            }
        }
    }

    public void uninstall() throws Exception {
        this.stop();
    }

    @Override
    public void rebind() throws Exception {
        this.stop();
        this.start();
    }
}

