/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.microcontainer.junit;

import java.util.HashSet;
import java.util.Set;
import org.jboss.aop.metadata.SimpleMetaData;
import org.jboss.aop.microcontainer.junit.AbstractProxyTestDelegate;
import org.jboss.aop.proxy.container.AOPProxyFactory;
import org.jboss.aop.proxy.container.AOPProxyFactoryMixin;
import org.jboss.aop.proxy.container.AOPProxyFactoryParameters;
import org.jboss.aop.proxy.container.GeneratedAOPProxyFactory;
import org.jboss.test.AbstractTestCaseWithSetup;
import org.jboss.test.AbstractTestDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProxyTest
extends AbstractTestCaseWithSetup {
    protected AOPProxyFactory proxyFactory;

    public static AbstractTestDelegate getDelegate(Class clazz) throws Exception {
        String property = System.getProperty("jboss.mc.secure", "false");
        boolean enableSecurity = Boolean.valueOf(property);
        AbstractProxyTestDelegate delegate = new AbstractProxyTestDelegate(clazz);
        delegate.enableSecurity = enableSecurity;
        return delegate;
    }

    public AbstractProxyTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.configureLogging();
        this.proxyFactory = new GeneratedAOPProxyFactory();
    }

    protected Object createProxy(Object target) throws Exception {
        AOPProxyFactoryParameters params = new AOPProxyFactoryParameters();
        params.setProxiedClass(target.getClass());
        params.setTarget(target);
        return this.proxyFactory.createAdvisedProxy(params);
    }

    protected Object assertCreateProxy(Object target, Class expected) throws Exception {
        Object proxy = this.createProxy(target);
        AbstractProxyTest.assertNotNull((Object)proxy);
        AbstractProxyTest.assertTrue((String)("Proxy " + proxy + " should implement " + expected.getName() + " interfaces=" + this.getInterfaces(proxy)), (boolean)expected.isInstance(proxy));
        return proxy;
    }

    protected Object createProxy(Object target, Class[] interfaces) throws Exception {
        AOPProxyFactoryParameters params = new AOPProxyFactoryParameters();
        params.setProxiedClass(target.getClass());
        params.setInterfaces(interfaces);
        params.setTarget(target);
        return this.proxyFactory.createAdvisedProxy(params);
    }

    protected Object createProxy(Object target, AOPProxyFactoryMixin[] mixins) throws Exception {
        AOPProxyFactoryParameters params = new AOPProxyFactoryParameters();
        params.setProxiedClass(target.getClass());
        params.setMixins(mixins);
        params.setTarget(target);
        return this.proxyFactory.createAdvisedProxy(params);
    }

    protected Object createProxy(Object target, Class[] interfaces, AOPProxyFactoryMixin[] mixins) throws Exception {
        AOPProxyFactoryParameters params = new AOPProxyFactoryParameters();
        params.setProxiedClass(target.getClass());
        params.setInterfaces(interfaces);
        params.setMixins(mixins);
        params.setTarget(target);
        return this.proxyFactory.createAdvisedProxy(params);
    }

    protected Object assertCreateProxy(Object target, AOPProxyFactoryMixin[] mixins, Class expected) throws Exception {
        Object proxy = this.createProxy(target, mixins);
        AbstractProxyTest.assertNotNull((Object)proxy);
        AbstractProxyTest.assertTrue((String)("Proxy " + proxy + " should implement " + expected.getName() + " interfaces=" + this.getInterfaces(proxy)), (boolean)expected.isInstance(proxy));
        return proxy;
    }

    protected Object assertCreateProxy(Object target, Class[] interfaces, AOPProxyFactoryMixin[] mixins, Class[] expected) throws Exception {
        Object proxy = this.createProxy(target, interfaces, mixins);
        AbstractProxyTest.assertNotNull((Object)proxy);
        for (int i = 0; i < expected.length; ++i) {
            AbstractProxyTest.assertTrue((String)("Proxy " + proxy + " should implement " + expected[i].getName() + " interfaces=" + this.getInterfaces(proxy)), (boolean)expected[i].isInstance(proxy));
        }
        return proxy;
    }

    protected Object assertCreateProxy(Object target, Class[] interfaces, Class expected) throws Exception {
        Object proxy = this.createProxy(target, interfaces);
        AbstractProxyTest.assertNotNull((Object)proxy);
        AbstractProxyTest.assertTrue((String)("Proxy " + proxy + " should implement " + expected.getName() + " interfaces=" + this.getInterfaces(proxy)), (boolean)expected.isInstance(proxy));
        return proxy;
    }

    protected Object createProxy(Object target, Class[] interfaces, SimpleMetaData metaData) throws Exception {
        AOPProxyFactoryParameters params = new AOPProxyFactoryParameters();
        params.setProxiedClass(target.getClass());
        params.setInterfaces(interfaces);
        params.setSimpleMetaData(metaData);
        params.setTarget(target);
        return this.proxyFactory.createAdvisedProxy(params);
    }

    protected Object assertCreateProxy(Object target, Class[] interfaces, SimpleMetaData metaData, Class expected) throws Exception {
        Object proxy = this.createProxy(target, interfaces, metaData);
        AbstractProxyTest.assertNotNull((Object)proxy);
        AbstractProxyTest.assertTrue((String)("Proxy " + proxy + " should implement " + expected.getName() + " interfaces=" + this.getInterfaces(proxy)), (boolean)expected.isInstance(proxy));
        return proxy;
    }

    protected Object createHollowProxy(Class[] interfaces, SimpleMetaData metaData) throws Exception {
        AOPProxyFactoryParameters params = new AOPProxyFactoryParameters();
        params.setInterfaces(interfaces);
        params.setSimpleMetaData(metaData);
        return this.proxyFactory.createAdvisedProxy(params);
    }

    protected Object createHollowProxy(AOPProxyFactoryMixin[] mixins, SimpleMetaData metaData) throws Exception {
        AOPProxyFactoryParameters params = new AOPProxyFactoryParameters();
        params.setMixins(mixins);
        params.setSimpleMetaData(metaData);
        return this.proxyFactory.createAdvisedProxy(params);
    }

    protected Object createHollowProxy(Class[] interfaces, AOPProxyFactoryMixin[] mixins, SimpleMetaData metaData) throws Exception {
        AOPProxyFactoryParameters params = new AOPProxyFactoryParameters();
        params.setInterfaces(interfaces);
        params.setMixins(mixins);
        params.setSimpleMetaData(metaData);
        return this.proxyFactory.createAdvisedProxy(params);
    }

    protected Object assertCreateHollowProxy(Class[] interfaces, SimpleMetaData metaData, Class expected) throws Exception {
        Object proxy = this.createHollowProxy(interfaces, metaData);
        AbstractProxyTest.assertNotNull((Object)proxy);
        AbstractProxyTest.assertTrue((String)("Proxy " + proxy + " should implement " + expected.getName() + " interfaces=" + this.getInterfaces(proxy)), (boolean)expected.isInstance(proxy));
        return proxy;
    }

    protected Object assertCreateHollowProxy(AOPProxyFactoryMixin[] mixins, SimpleMetaData metaData, Class expected) throws Exception {
        Object proxy = this.createHollowProxy(mixins, metaData);
        AbstractProxyTest.assertNotNull((Object)proxy);
        AbstractProxyTest.assertTrue((String)("Proxy " + proxy + " should implement " + expected.getName() + " interfaces=" + this.getInterfaces(proxy)), (boolean)expected.isInstance(proxy));
        return proxy;
    }

    protected Object assertCreateHollowProxy(Class[] interfaces, AOPProxyFactoryMixin[] mixins, SimpleMetaData metaData, Class[] expected) throws Exception {
        Object proxy = this.createHollowProxy(interfaces, mixins, metaData);
        AbstractProxyTest.assertNotNull((Object)proxy);
        for (int i = 0; i < expected.length; ++i) {
            AbstractProxyTest.assertTrue((String)("Proxy " + proxy + " should implement " + expected[i].getName() + " interfaces=" + this.getInterfaces(proxy)), (boolean)expected[i].isInstance(proxy));
        }
        return proxy;
    }

    protected Set getInterfaces(Object object) {
        HashSet<Class> interfaces = new HashSet<Class>();
        this.addInterfaces(interfaces, object.getClass());
        return interfaces;
    }

    protected void addInterfaces(Set<Class> interfaces, Class clazz) {
        Class<?>[] intfs = clazz.getInterfaces();
        for (int i = 0; i < intfs.length; ++i) {
            interfaces.add(intfs[i]);
        }
        Class superClass = clazz.getSuperclass();
        if (superClass != null) {
            this.addInterfaces(interfaces, superClass);
        }
    }

    protected AbstractProxyTestDelegate getMCDelegate() {
        return (AbstractProxyTestDelegate)this.getDelegate();
    }
}

