/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.metadata.plugins;

import java.io.Serializable;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.beans.metadata.plugins.AbstractLifecycleMetaData;
import org.jboss.beans.metadata.plugins.CallbackCreatorUtil;
import org.jboss.beans.metadata.spi.CallbackMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitor;
import org.jboss.dependency.spi.CallbackItem;
import org.jboss.dependency.spi.Cardinality;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.plugins.config.Configurator;
import org.jboss.kernel.plugins.dependency.CallbackDependencyItem;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.util.JBossStringBuilder;

public abstract class AbstractCallbackMetaData
extends AbstractLifecycleMetaData
implements CallbackMetaData,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Cardinality cardinality;
    protected String property;
    protected ControllerState whenRequired = ControllerState.CONFIGURED;
    protected ControllerState dependentState = ControllerState.INSTALLED;
    protected String signature;
    protected transient PropertyInfo propertyInfo;
    protected transient MethodInfo methodInfo;

    public AbstractCallbackMetaData() {
        this.setState(ControllerState.CONFIGURED);
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
        this.flushJBossObjectCache();
    }

    public Cardinality getCardinality() {
        return this.cardinality;
    }

    public void setCardinality(Cardinality cardinality) {
        this.cardinality = cardinality;
        this.flushJBossObjectCache();
    }

    public ControllerState getWhenRequiredState() {
        return this.whenRequired;
    }

    public void setWhenRequired(ControllerState whenRequired) {
        this.whenRequired = whenRequired;
        this.flushJBossObjectCache();
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
        this.flushJBossObjectCache();
    }

    public void setDependentState(ControllerState dependentState) {
        this.dependentState = dependentState;
        this.flushJBossObjectCache();
    }

    public ControllerState getDependentState() {
        return this.dependentState;
    }

    public void setPropertyInfo(PropertyInfo propertyInfo) {
        this.propertyInfo = propertyInfo;
        this.property = propertyInfo.getName();
    }

    public void setMethodInfo(MethodInfo methodInfo) {
        this.methodInfo = methodInfo;
        this.methodName = methodInfo.getName();
    }

    protected abstract void addCallback(MetaDataVisitor var1, CallbackItem var2);

    public void describeVisit(MetaDataVisitor vistor) {
        try {
            CallbackItem<Class> callback;
            KernelControllerContext context = vistor.getControllerContext();
            if (this.property != null) {
                if (this.propertyInfo == null) {
                    ClassLoader cl = Configurator.getClassLoader(context.getBeanMetaData());
                    this.propertyInfo = Configurator.resolveProperty(this.log.isTraceEnabled(), context.getBeanInfo(), cl, this.property, this.signature);
                }
                callback = CallbackCreatorUtil.createCallback(context, this.propertyInfo, this.whenRequired, this.dependentState, this.cardinality);
            } else if (this.methodName != null) {
                if (this.methodInfo == null) {
                    this.methodInfo = Configurator.findMethodInfo(this.getClassInfo(context), this.methodName, new String[]{this.signature});
                }
                callback = CallbackCreatorUtil.createCallback(context, this.methodInfo, this.whenRequired, this.dependentState, this.cardinality);
            } else {
                throw new IllegalArgumentException("Illegal usage - not property or method:" + this);
            }
            this.addCallback(vistor, callback);
            if (this.cardinality != null) {
                vistor.addDependency(new CallbackDependencyItem(context.getName(), callback.getIDependOn(), this.whenRequired, this.dependentState, this.cardinality));
            }
        }
        catch (Throwable t) {
            throw new Error(t);
        }
        super.describeVisit(vistor);
    }

    public void toString(JBossStringBuilder buffer) {
        super.toString(buffer);
        if (this.property != null) {
            buffer.append(" property=").append(this.property);
        }
        if (this.cardinality != null) {
            buffer.append(" cardinality=").append(this.cardinality);
        }
        if (this.signature != null) {
            buffer.append(" signature=").append(this.signature);
        }
        if (!ControllerState.INSTALLED.equals(this.dependentState)) {
            buffer.append(" dependentState=" + this.dependentState);
        }
        if (!ControllerState.CONFIGURED.equals(this.whenRequired)) {
            buffer.append(" whenRequiredState=" + this.dependentState);
        }
    }

    public void toShortString(JBossStringBuilder buffer) {
        if (this.property != null) {
            buffer.append("property=").append(this.property);
        }
        if (this.methodName != null) {
            buffer.append("method=").append(this.methodName);
        }
    }
}

