/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.plugins.structure;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentResourceLoader;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VFSDeploymentResourceLoaderImpl
implements VFSDeploymentResourceLoader {
    private VirtualFile root;

    public VFSDeploymentResourceLoaderImpl(VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException("Null root");
        }
        this.root = root;
    }

    @Override
    public VirtualFile getFile(String path) {
        try {
            return this.root.findChild(path);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public URL getResource(String name) {
        try {
            VirtualFile child = this.root.findChild(name);
            return child.toURL();
        }
        catch (URISyntaxException e) {
            return null;
        }
        catch (MalformedURLException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        try {
            VirtualFile child = this.root.findChild(name);
            Vector<URL> vector = new Vector<URL>();
            vector.add(child.toURL());
            return vector.elements();
        }
        catch (URISyntaxException e) {
            return null;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

