/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment.dependency;

import java.util.Iterator;
import org.jboss.beans.metadata.spi.DependencyMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitor;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.deployment.dependency.JndiDependencyItem;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.logging.Logger;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JndiDependencyMetaData
extends JBossObject
implements DependencyMetaData {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(JndiDependencyMetaData.class);
    private String jndiName;
    private Object demand;
    private ClassLoader loader;
    private ControllerState whenRequired = ControllerState.INSTALLED;

    public JndiDependencyMetaData(String jndiName, ClassLoader loader, ControllerState whenRequired) {
        this.jndiName = jndiName;
        this.loader = loader;
    }

    @Override
    public Object getDependency() {
        return this.demand;
    }

    public ControllerState getWhenRequired() {
        return this.whenRequired;
    }

    @Override
    public void describeVisit(MetaDataVisitor vistor) {
        vistor.describeVisit(this);
    }

    @Override
    public Iterator<? extends MetaDataVisitorNode> getChildren() {
        return null;
    }

    @Override
    public void initialVisit(MetaDataVisitor visitor) {
        KernelControllerContext context = visitor.getControllerContext();
        JndiDependencyItem item = new JndiDependencyItem(this.jndiName, this.loader, this.whenRequired);
        visitor.addDependency(item);
        visitor.initialVisit(this);
    }

    @Override
    public String toShortString() {
        JBossStringBuilder buffer = new JBossStringBuilder();
        this.toShortString(buffer);
        return buffer.toString();
    }

    @Override
    public void toShortString(JBossStringBuilder buffer) {
        buffer.append(this.jndiName);
    }
}

