/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb;

import java.util.HashMap;
import javax.naming.InitialContext;
import org.jboss.ejb.BeanLock;
import org.jboss.ejb.Container;
import org.jboss.logging.Logger;
import org.jboss.monitor.EntityLockMonitor;
import org.jboss.monitor.LockMonitor;

public class BeanLockManager {
    private static final int NUMBER_OF_INSTANCES = 40;
    private static Logger log = Logger.getLogger(BeanLockManager.class);
    private HashMap[] map = new HashMap[40];
    private Container container;
    private boolean reentrant = false;
    private int txTimeout = 5000;
    private boolean trace;
    public Class lockClass;
    protected LockMonitor monitor = null;

    private BeanLockManager() {
        for (int i = 0; i < this.map.length; ++i) {
            this.map[i] = new HashMap();
        }
    }

    public BeanLockManager(Container container) {
        this();
        this.container = container;
        this.trace = log.isTraceEnabled();
        try {
            InitialContext ctx = new InitialContext();
            EntityLockMonitor elm = (EntityLockMonitor)ctx.lookup("EntityLockMonitor");
            String jndiName = container.getBeanMetaData().getContainerObjectNameJndiName();
            this.monitor = elm.getEntityLockMonitor(jndiName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public LockMonitor getLockMonitor() {
        return this.monitor;
    }

    private HashMap getHashMap(Object id) {
        int mapInUse = id.hashCode() % 40;
        if (mapInUse > 0) {
            return this.map[mapInUse];
        }
        return this.map[mapInUse * -1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeanLock getLock(Object id) {
        HashMap mapInUse;
        if (id == null) {
            throw new IllegalArgumentException("Attempt to get lock ref with a null object");
        }
        HashMap hashMap = mapInUse = this.getHashMap(id);
        synchronized (hashMap) {
            BeanLock lock = (BeanLock)mapInUse.get(id);
            if (lock != null) {
                lock.addRef();
                return lock;
            }
        }
        try {
            BeanLock lock2 = this.createLock(id);
            HashMap hashMap2 = mapInUse;
            synchronized (hashMap2) {
                BeanLock lock = (BeanLock)mapInUse.get(id);
                if (lock != null) {
                    lock.addRef();
                    return lock;
                }
                mapInUse.put(id, lock2);
                lock2.addRef();
                return lock2;
            }
        }
        catch (Exception e) {
            log.warn("Failed to initialize lock:" + id, e);
            throw new RuntimeException(e);
        }
    }

    private BeanLock createLock(Object id) throws Exception {
        BeanLock lock = (BeanLock)this.lockClass.newInstance();
        lock.setId(id);
        lock.setTimeout(this.txTimeout);
        lock.setContainer(this.container);
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLockRef(Object id) {
        HashMap mapInUse;
        if (id == null) {
            throw new IllegalArgumentException("Attempt to remove lock ref with a null object");
        }
        HashMap hashMap = mapInUse = this.getHashMap(id);
        synchronized (hashMap) {
            BeanLock lock = (BeanLock)mapInUse.get(id);
            if (lock != null) {
                try {
                    lock.removeRef();
                    if (this.trace) {
                        log.trace("Remove ref lock:" + lock);
                    }
                    Object var6_5 = null;
                    if (lock.getRefs() <= 0) {
                        Object mapLock = mapInUse.remove(lock.getId());
                        if (this.trace) {
                            log.trace("Lock no longer referenced, lock: " + lock);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    if (lock.getRefs() <= 0) {
                        Object mapLock = mapInUse.remove(lock.getId());
                        if (this.trace) {
                            log.trace("Lock no longer referenced, lock: " + lock);
                        }
                    }
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canPassivate(Object id) {
        HashMap mapInUse;
        if (id == null) {
            throw new IllegalArgumentException("Attempt to passivate with a null object");
        }
        HashMap hashMap = mapInUse = this.getHashMap(id);
        synchronized (hashMap) {
            BeanLock lock = (BeanLock)mapInUse.get(id);
            if (lock == null) {
                throw new IllegalStateException("Attempt to passivate without a lock");
            }
            return lock.getRefs() <= 1;
        }
    }

    public void setLockCLass(Class lockClass) {
        this.lockClass = lockClass;
    }

    public void setReentrant(boolean reentrant) {
        this.reentrant = reentrant;
    }

    public void setContainer(Container container) {
        this.container = container;
    }
}

