/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCValuePropertyMetaData;
import org.jboss.metadata.MetaData;
import org.w3c.dom.Element;

public final class JDBCValueClassMetaData {
    private final Class javaType;
    private final List properties;

    public JDBCValueClassMetaData(Element classElement, ClassLoader classLoader) throws DeploymentException {
        String className = MetaData.getUniqueChildContent(classElement, "class");
        try {
            this.javaType = classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException("dependent-value-class not found: " + className);
        }
        ArrayList<JDBCValuePropertyMetaData> propertyList = new ArrayList<JDBCValuePropertyMetaData>();
        Iterator iterator = MetaData.getChildrenByTagName(classElement, "property");
        while (iterator.hasNext()) {
            Element propertyElement = (Element)iterator.next();
            propertyList.add(new JDBCValuePropertyMetaData(propertyElement, this.javaType));
        }
        this.properties = Collections.unmodifiableList(propertyList);
    }

    public Class getJavaType() {
        return this.javaType;
    }

    public List getProperties() {
        return this.properties;
    }
}

