/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc.metadata;

import java.lang.reflect.Method;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCMappingMetaData;
import org.jboss.metadata.MetaData;
import org.w3c.dom.Element;

public final class JDBCValuePropertyMetaData {
    private final String propertyName;
    private final Class propertyType;
    private final String columnName;
    private final String sqlType;
    private final int jdbcType;
    private final boolean notNull;
    private final Method getter;
    private final Method setter;

    public JDBCValuePropertyMetaData(Element element, Class classType) throws DeploymentException {
        this.propertyName = MetaData.getUniqueChildContent(element, "property-name");
        String columnNameString = MetaData.getOptionalChildContent(element, "column-name");
        this.columnName = columnNameString != null ? columnNameString : this.propertyName;
        Element notNullElement = MetaData.getOptionalChild(element, "not-null");
        this.notNull = notNullElement != null;
        try {
            this.getter = classType.getMethod(JDBCValuePropertyMetaData.toGetterName(this.propertyName), new Class[0]);
        }
        catch (Exception e) {
            throw new DeploymentException("Unable to find getter for property " + this.propertyName + " on dependent value class " + classType.getName());
        }
        this.propertyType = this.getter.getReturnType();
        try {
            this.setter = classType.getMethod(JDBCValuePropertyMetaData.toSetterName(this.propertyName), this.propertyType);
        }
        catch (Exception e) {
            throw new DeploymentException("Unable to find setter for property " + this.propertyName + " on dependent value class " + classType.getName());
        }
        String jdbcString = MetaData.getOptionalChildContent(element, "jdbc-type");
        if (jdbcString != null) {
            this.jdbcType = JDBCMappingMetaData.getJdbcTypeFromName(jdbcString);
            this.sqlType = MetaData.getUniqueChildContent(element, "sql-type");
        } else {
            this.jdbcType = Integer.MIN_VALUE;
            this.sqlType = null;
        }
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Class getPropertyType() {
        return this.propertyType;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public int getJDBCType() {
        return this.jdbcType;
    }

    public String getSqlType() {
        return this.sqlType;
    }

    public boolean isNotNull() {
        return this.notNull;
    }

    public Method getGetter() {
        return this.getter;
    }

    public Method getSetter() {
        return this.setter;
    }

    private static String toGetterName(String propertyName) {
        return "get" + JDBCValuePropertyMetaData.upCaseFirstCharacter(propertyName);
    }

    private static String toSetterName(String propertyName) {
        return "set" + JDBCValuePropertyMetaData.upCaseFirstCharacter(propertyName);
    }

    private static String upCaseFirstCharacter(String propertyName) {
        return Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
    }
}

