/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc2;

import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.GenericEntityObjectFactory;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCEntityPersistenceStore;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCTypeFactory;
import org.jboss.ejb.plugins.cmp.jdbc.QueryParameter;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCFunctionMappingMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCTypeMappingMetaData;
import org.jboss.ejb.plugins.cmp.jdbc2.AbstractQueryCommand;
import org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCCMPFieldBridge2;
import org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCEntityBridge2;
import org.jboss.ejb.plugins.cmp.jdbc2.schema.Schema;
import org.jboss.logging.Logger;

public class FindByPrimaryKeyCommand
extends AbstractQueryCommand {
    public FindByPrimaryKeyCommand(JDBCEntityBridge2 entity) throws DeploymentException {
        this.entity = entity;
        JDBCCMPFieldBridge2[] fields = (JDBCCMPFieldBridge2[])entity.getTableFields();
        String selectColumns = fields[0].getColumnName();
        for (int i = 1; i < fields.length; ++i) {
            selectColumns = selectColumns + ", " + fields[i].getColumnName();
        }
        JDBCCMPFieldBridge2[] pkFields = (JDBCCMPFieldBridge2[])entity.getPrimaryKeyFields();
        String whereColumns = pkFields[0].getColumnName() + "=?";
        for (int i = 1; i < pkFields.length; ++i) {
            whereColumns = whereColumns + " and " + pkFields[i].getColumnName() + "=?";
        }
        if (entity.getMetaData().hasRowLocking()) {
            JDBCEntityPersistenceStore manager = entity.getManager();
            JDBCTypeFactory typeFactory = manager.getJDBCTypeFactory();
            JDBCTypeMappingMetaData typeMapping = typeFactory.getTypeMapping();
            JDBCFunctionMappingMetaData rowLockingTemplate = typeMapping.getRowLockingTemplate();
            if (rowLockingTemplate == null) {
                throw new DeploymentException("Row locking template is not defined for mapping: " + typeMapping.getName());
            }
            this.sql = rowLockingTemplate.getFunctionSql(new Object[]{selectColumns, entity.getQualifiedTableName(), whereColumns, null}, new StringBuffer()).toString();
        } else {
            this.sql = "select ";
            this.sql = this.sql + selectColumns;
            this.sql = this.sql + " from " + entity.getQualifiedTableName() + " where ";
            this.sql = this.sql + whereColumns;
        }
        this.log = Logger.getLogger(this.getClass().getName() + "." + entity.getEntityName() + "#findByPrimaryKey");
        this.log.debug("sql: " + this.sql);
        this.setParameters(QueryParameter.createPrimaryKeyParameters(0, entity));
        this.setEntityReader(entity, false);
    }

    public Object fetchOne(Schema schema, GenericEntityObjectFactory factory, Object[] args) throws FinderException {
        Object instance;
        Object pk = args[0];
        if (pk == null) {
            throw new IllegalArgumentException("Null argument for findByPrimaryKey");
        }
        boolean cached = this.entity.getTable().hasRow(pk);
        if (!cached) {
            instance = super.executeFetchOne(args, factory);
            if (instance == null) {
                throw new ObjectNotFoundException("Instance not find: entity=" + this.entity.getEntityName() + ", pk=" + pk);
            }
        } else {
            instance = factory.getEntityEJBObject(pk);
        }
        return instance;
    }
}

