/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.txtimer;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.security.RunAs;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextFactory;
import org.jboss.security.plugins.SecurityContextAssociation;

public class SecurityActions {
    static ClassLoader getContextClassLoader() {
        return TCLAction.UTIL.getContextClassLoader();
    }

    static ClassLoader getContextClassLoader(Thread thread) {
        return TCLAction.UTIL.getContextClassLoader(thread);
    }

    static SecurityContext createSecurityContext(final String securityDomain) throws PrivilegedActionException {
        return (SecurityContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                SecurityContext sc = SecurityContextFactory.createSecurityContext(securityDomain);
                SecurityContextAssociation.setSecurityContext(sc);
                return sc;
            }
        });
    }

    static SecurityContext getSecurityContext() {
        return (SecurityContext)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return SecurityContextAssociation.getSecurityContext();
            }
        });
    }

    static void setSecurityContext(final SecurityContext sc) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SecurityContextAssociation.setSecurityContext(sc);
                return null;
            }
        });
    }

    static void setContextClassLoader(ClassLoader loader) {
        TCLAction.UTIL.setContextClassLoader(loader);
    }

    static void setContextClassLoader(Thread thread, ClassLoader loader) {
        TCLAction.UTIL.setContextClassLoader(thread, loader);
    }

    static void pushRunAsIdentity(RunAs principal) {
        if (System.getSecurityManager() == null) {
            RunAsIdentityActions.NON_PRIVILEGED.push(principal);
        } else {
            RunAsIdentityActions.PRIVILEGED.push(principal);
        }
    }

    static RunAs popRunAsIdentity() {
        if (System.getSecurityManager() == null) {
            return RunAsIdentityActions.NON_PRIVILEGED.pop();
        }
        return RunAsIdentityActions.PRIVILEGED.pop();
    }

    static interface TCLAction {
        public static final TCLAction NON_PRIVILEGED = new TCLAction(){

            public ClassLoader getContextClassLoader() {
                return Thread.currentThread().getContextClassLoader();
            }

            public ClassLoader getContextClassLoader(Thread thread) {
                return thread.getContextClassLoader();
            }

            public void setContextClassLoader(ClassLoader cl) {
                Thread.currentThread().setContextClassLoader(cl);
            }

            public void setContextClassLoader(Thread thread, ClassLoader cl) {
                thread.setContextClassLoader(cl);
            }
        };
        public static final TCLAction PRIVILEGED = new TCLAction(){
            private final PrivilegedAction getTCLPrivilegedAction = new PrivilegedAction(){

                public Object run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            };

            public ClassLoader getContextClassLoader() {
                return (ClassLoader)AccessController.doPrivileged(this.getTCLPrivilegedAction);
            }

            public ClassLoader getContextClassLoader(final Thread thread) {
                return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return thread.getContextClassLoader();
                    }
                });
            }

            public void setContextClassLoader(final ClassLoader cl) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Thread.currentThread().setContextClassLoader(cl);
                        return null;
                    }
                });
            }

            public void setContextClassLoader(final Thread thread, final ClassLoader cl) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        thread.setContextClassLoader(cl);
                        return null;
                    }
                });
            }
        };

        public ClassLoader getContextClassLoader();

        public ClassLoader getContextClassLoader(Thread var1);

        public void setContextClassLoader(ClassLoader var1);

        public void setContextClassLoader(Thread var1, ClassLoader var2);

        public static class UTIL {
            static TCLAction getTCLAction() {
                return System.getSecurityManager() == null ? NON_PRIVILEGED : PRIVILEGED;
            }

            static ClassLoader getContextClassLoader() {
                return UTIL.getTCLAction().getContextClassLoader();
            }

            static ClassLoader getContextClassLoader(Thread thread) {
                return UTIL.getTCLAction().getContextClassLoader(thread);
            }

            static void setContextClassLoader(ClassLoader cl) {
                UTIL.getTCLAction().setContextClassLoader(cl);
            }

            static void setContextClassLoader(Thread thread, ClassLoader cl) {
                UTIL.getTCLAction().setContextClassLoader(thread, cl);
            }
        }
    }

    static interface RunAsIdentityActions {
        public static final RunAsIdentityActions PRIVILEGED = new RunAsIdentityActions(){
            private final PrivilegedAction peekAction = new PrivilegedAction(){

                public Object run() {
                    SecurityContext sc = SecurityActions.getSecurityContext();
                    if (sc == null) {
                        throw new IllegalStateException("Security Context is null");
                    }
                    return sc.getOutgoingRunAs();
                }
            };
            private final PrivilegedAction popAction = new PrivilegedAction(){

                public Object run() {
                    SecurityContext sc = SecurityActions.getSecurityContext();
                    if (sc == null) {
                        throw new IllegalStateException("Security Context is null");
                    }
                    RunAs ra = sc.getOutgoingRunAs();
                    sc.setOutgoingRunAs(null);
                    return ra;
                }
            };

            public RunAs peek() {
                return (RunAs)AccessController.doPrivileged(this.peekAction);
            }

            public void push(final RunAs id) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        SecurityContext sc = SecurityActions.getSecurityContext();
                        if (sc == null) {
                            throw new IllegalStateException("Security Context is null");
                        }
                        sc.setOutgoingRunAs(id);
                        return null;
                    }
                });
            }

            public RunAs pop() {
                return (RunAs)AccessController.doPrivileged(this.popAction);
            }
        };
        public static final RunAsIdentityActions NON_PRIVILEGED = new RunAsIdentityActions(){

            public RunAs peek() {
                SecurityContext sc = SecurityActions.getSecurityContext();
                if (sc == null) {
                    throw new IllegalStateException("Security Context is null");
                }
                return sc.getOutgoingRunAs();
            }

            public void push(RunAs id) {
                SecurityContext sc = SecurityActions.getSecurityContext();
                if (sc == null) {
                    throw new IllegalStateException("Security Context is null");
                }
                sc.setOutgoingRunAs(id);
            }

            public RunAs pop() {
                SecurityContext sc = SecurityActions.getSecurityContext();
                if (sc == null) {
                    throw new IllegalStateException("Security Context is null");
                }
                RunAs ra = sc.getOutgoingRunAs();
                sc.setOutgoingRunAs(null);
                return ra;
            }
        };

        public RunAs peek();

        public void push(RunAs var1);

        public RunAs pop();
    }
}

