/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.asynchronous;

import java.security.Principal;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aspects.asynch.AsynchAspect;
import org.jboss.aspects.asynch.ExecutorAbstraction;
import org.jboss.aspects.asynch.Future;
import org.jboss.aspects.asynch.FutureHolder;
import org.jboss.aspects.asynch.ThreadPoolExecutor;
import org.jboss.aspects.tx.ClientTxPropagationInterceptor;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;
import org.jboss.security.SecurityAssociation;
import org.jboss.tm.TransactionPropagationContextFactory;
import org.jboss.tm.TransactionPropagationContextUtil;

public class AsynchronousInterceptor
extends AsynchAspect
implements Interceptor {
    private static final Logger log = Logger.getLogger(AsynchronousInterceptor.class);
    public static final String ASYNCH = "ASYNCH";
    public static final String INVOKE_ASYNCH = "INVOKE_ASYNCH";
    public static final String FUTURE_HOLDER = "FUTURE_HOLDER";

    public AsynchronousInterceptor() {
        try {
            this.executor = (ExecutorAbstraction)ThreadPoolExecutor.class.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public String getName() {
        return "AsynchronousInterceptor";
    }

    public Object invoke(Invocation invocation) throws Throwable {
        MethodInvocation mi = (MethodInvocation)invocation;
        if (invocation.getMetaData(ASYNCH, INVOKE_ASYNCH) != null) {
            InvokerLocator locator = (InvokerLocator)invocation.getMetaData("REMOTING", "INVOKER_LOCATOR");
            if (locator == null) {
                Object credential;
                Principal principal;
                Object tpc;
                TransactionPropagationContextFactory tpcFactory = TransactionPropagationContextUtil.getTPCFactoryClientSide();
                if (tpcFactory != null && (tpc = tpcFactory.getTransactionPropagationContext()) != null) {
                    invocation.getMetaData().addMetaData(ClientTxPropagationInterceptor.TRANSACTION_PROPAGATION_CONTEXT, ClientTxPropagationInterceptor.TRANSACTION_PROPAGATION_CONTEXT, tpc);
                }
                if ((principal = SecurityAssociation.getPrincipal()) != null) {
                    invocation.getMetaData().addMetaData("security", "principal", principal);
                }
                if ((credential = SecurityAssociation.getCredential()) != null) {
                    invocation.getMetaData().addMetaData("security", "credential", credential);
                }
            }
            return super.execute(mi);
        }
        return mi.invokeNext();
    }

    protected void setupLocalFuture(MethodInvocation invocation, Future future) {
        FutureHolder provider = (FutureHolder)invocation.getMetaData(ASYNCH, FUTURE_HOLDER);
        provider.setFuture(future);
    }

    protected boolean generateProxy() {
        return false;
    }
}

