/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.dependency;

import java.io.Serializable;
import java.util.Iterator;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import org.jboss.beans.metadata.spi.DemandMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitor;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.dependency.plugins.AbstractDependencyItem;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.logging.Logger;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JndiDemandMetaData
extends JBossObject
implements DemandMetaData,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(JndiDemandMetaData.class);
    private String jndiName;
    private Object demand;
    private ClassLoader loader;
    private ControllerState whenRequired = ControllerState.INSTALLED;

    public JndiDemandMetaData(String jndiName, ClassLoader loader) {
        this.jndiName = jndiName;
        this.loader = loader;
    }

    @Override
    public Object getDemand() {
        return this.demand;
    }

    @Override
    public ControllerState getWhenRequired() {
        return this.whenRequired;
    }

    @Override
    public void describeVisit(MetaDataVisitor vistor) {
        vistor.describeVisit(this);
    }

    @Override
    public Iterator<? extends MetaDataVisitorNode> getChildren() {
        return null;
    }

    @Override
    public void initialVisit(MetaDataVisitor visitor) {
        KernelControllerContext context = visitor.getControllerContext();
        JndiDemandDependencyItem item = new JndiDemandDependencyItem(context.getName());
        visitor.addDependency(item);
        visitor.initialVisit(this);
    }

    @Override
    public void toString(JBossStringBuilder buffer) {
        buffer.append("demand=").append(this.jndiName);
        buffer.append(" whenRequired=").append(this.whenRequired.getStateString());
    }

    @Override
    public void toShortString(JBossStringBuilder buffer) {
        buffer.append(this.jndiName);
    }

    private class JndiDemandDependencyItem
    extends AbstractDependencyItem {
        public JndiDemandDependencyItem(Object name) {
            super(name, null, JndiDemandMetaData.this.whenRequired, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean resolve(Controller controller) {
            ClassLoader tcl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(JndiDemandMetaData.this.loader);
                InitialContext ctx = new InitialContext();
                JndiDemandMetaData.this.demand = ctx.lookup(JndiDemandMetaData.this.jndiName);
                this.setResolved(true);
                boolean bl = this.isResolved();
                return bl;
            }
            catch (NameNotFoundException e) {
            }
            catch (Throwable ignored) {
                if (log.isTraceEnabled()) {
                    log.trace("Unexpected error", ignored);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(tcl);
            }
            this.setResolved(false);
            return this.isResolved();
        }

        public void toString(JBossStringBuilder buffer) {
            super.toString(buffer);
            buffer.append(" demand=").append(JndiDemandMetaData.this.jndiName);
        }

        public void toShortString(JBossStringBuilder buffer) {
            buffer.append(this.getName()).append(" demands ").append(JndiDemandMetaData.this.jndiName);
        }

        public String toHumanReadableString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Demands '").append(JndiDemandMetaData.this.jndiName);
            return builder.toString();
        }
    }
}

