/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.enc;

import java.util.HashMap;
import java.util.Map;
import org.jboss.ejb3.DeploymentScope;
import org.jboss.ejb3.Ejb3Deployment;
import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.spec.MessageDestinationMetaData;
import org.jboss.metadata.javaee.spec.MessageDestinationsMetaData;

public class MessageDestinationResolver {
    private static final Logger log = Logger.getLogger(MessageDestinationResolver.class);
    private DeploymentScope deploymentScope;
    private Map<String, MessageDestinationMetaData> messageDestinations = new HashMap<String, MessageDestinationMetaData>();

    public MessageDestinationResolver(DeploymentScope deploymentScope, MessageDestinationsMetaData mergedMessageDestinations) {
        this.deploymentScope = deploymentScope;
        if (mergedMessageDestinations != null) {
            for (MessageDestinationMetaData dest : mergedMessageDestinations) {
                this.messageDestinations.put(dest.getMessageDestinationName(), dest);
            }
        }
    }

    private String getMessageDestinationJNDIName(String name) {
        MessageDestinationMetaData dest = this.messageDestinations.get(name);
        if (dest != null) {
            return dest.getJndiName();
        }
        return null;
    }

    public String resolveMessageDestination(String link) {
        int hashIndex = link.indexOf(35);
        if (hashIndex != -1) {
            if (this.deploymentScope == null) {
                log.warn("Message destination link '" + link + "' is relative, but no deployment scope found");
                return null;
            }
            String relativePath = link.substring(0, hashIndex);
            Ejb3Deployment dep = this.deploymentScope.findRelativeDeployment(relativePath);
            if (dep == null) {
                log.warn("Can't find a deployment for path '" + relativePath + "' of message destination link '" + link + "'");
                return null;
            }
            String name = link.substring(hashIndex + 1);
            return dep.resolveMessageDestination(name);
        }
        String jndiName = this.getMessageDestinationJNDIName(link);
        if (jndiName != null) {
            return jndiName;
        }
        for (Ejb3Deployment dep : this.deploymentScope.getEjbDeployments()) {
            jndiName = dep.getMessageDestinationResolver().getMessageDestinationJNDIName(link);
            if (jndiName == null) continue;
            return jndiName;
        }
        log.warn("Can't find a message destination for link '" + link + "' anywhere");
        return null;
    }
}

