/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.jndipolicy.impl;

import org.jboss.ejb3.jndipolicy.DefaultJndiBindingPolicy;
import org.jboss.ejb3.jndipolicy.Ejb3DeploymentSummary;

public class PackagingBasedJndiBindingPolicy
implements DefaultJndiBindingPolicy {
    private static final String JNDI_SUFFIX_REMOTE = "/remote";
    private static final String JNDI_SUFFIX_LOCAL = "/local";
    private static final String JNDI_SUFFIX_REMOTE_HOME = "/home";
    private static final String JNDI_SUFFIX_LOCAL_HOME = "/localHome";

    public String getJndiName(Ejb3DeploymentSummary summary) {
        if (!summary.isLocal()) {
            if (summary.isHome()) {
                return this.getDefaultRemoteHomeJndiName(summary);
            }
            return this.getDefaultRemoteJndiName(summary);
        }
        if (summary.isHome()) {
            return this.getDefaultLocalHomeJndiName(summary);
        }
        return this.getDefaultLocalJndiName(summary);
    }

    public String getDefaultRemoteJndiName(Ejb3DeploymentSummary summary) {
        String name = summary.getEjbName() + JNDI_SUFFIX_REMOTE;
        if (summary.getDeploymentScopeBaseName() != null) {
            name = summary.getDeploymentScopeBaseName() + "/" + name;
        }
        return name;
    }

    public String getDefaultRemoteHomeJndiName(Ejb3DeploymentSummary summary) {
        return summary.getEjbName() + JNDI_SUFFIX_REMOTE_HOME;
    }

    public String getDefaultLocalHomeJndiName(Ejb3DeploymentSummary summary) {
        return summary.getEjbName() + JNDI_SUFFIX_LOCAL_HOME;
    }

    public String getDefaultLocalJndiName(Ejb3DeploymentSummary summary) {
        String name = summary.getEjbName() + JNDI_SUFFIX_LOCAL;
        if (summary.getDeploymentScopeBaseName() != null) {
            name = summary.getDeploymentScopeBaseName() + "/" + name;
        }
        return name;
    }
}

