/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.kernel;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.jboss.ejb3.InitialContextFactory;
import org.jboss.kernel.plugins.registry.AbstractKernelRegistryEntry;
import org.jboss.kernel.spi.registry.KernelRegistryEntry;
import org.jboss.kernel.spi.registry.KernelRegistryPlugin;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JNDIKernelRegistryPlugin
implements KernelRegistryPlugin {
    private static final Logger log = Logger.getLogger(JNDIKernelRegistryPlugin.class);
    public static final String JNDI_DEPENDENCY_PREFIX = "jndi:";
    private Context context;
    private Hashtable<?, ?> environment;

    public JNDIKernelRegistryPlugin() {
    }

    public JNDIKernelRegistryPlugin(Hashtable environment) {
        this.environment = environment;
    }

    public void create() throws NamingException {
        log.debug("Creating JNDIKernelRegistryPlugin");
        this.context = InitialContextFactory.getInitialContext(this.environment);
    }

    public void destroy() throws NamingException {
        log.debug("Destroying JNDIKernelRegistryPlugin");
        if (this.context != null) {
            this.context.close();
        }
        this.context = null;
    }

    @Override
    public KernelRegistryEntry getEntry(Object name) {
        assert (name != null) : "name is null";
        String s = String.valueOf(name);
        if (!s.startsWith(JNDI_DEPENDENCY_PREFIX)) {
            return null;
        }
        if (log.isTraceEnabled()) {
            log.trace("get entry for " + name);
        }
        try {
            Object target = this.context.lookup(s.substring(JNDI_DEPENDENCY_PREFIX.length()));
            if (log.isTraceEnabled()) {
                log.trace("found: " + target);
            }
            return new AbstractKernelRegistryEntry(name, target);
        }
        catch (NameNotFoundException e) {
            log.trace("not found");
            return null;
        }
        catch (NamingException e) {
            log.trace("entry can't be resolved", e);
            throw new RuntimeException(e);
        }
        catch (RuntimeException e) {
            log.trace("entry can't be resolved", e);
            throw e;
        }
    }

    public void setEnvironment(Hashtable<?, ?> env) {
        if (this.context != null) {
            throw new IllegalStateException("context already initialized");
        }
        this.environment = env;
    }
}

