/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateful;

import java.rmi.RemoteException;
import javax.ejb.EJBException;
import javax.ejb.SessionSynchronization;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.ejb3.stateful.StatefulBeanContext;
import org.jboss.ejb3.stateful.StatefulContainer;
import org.jboss.ejb3.stateful.StatefulContainerInvocation;
import org.jboss.ejb3.tx.TxUtil;

public class SessionSynchronizationInterceptor
implements Interceptor {
    private TransactionManager tm = TxUtil.getTransactionManager();

    public String getName() {
        return null;
    }

    protected void registerSessionSynchronization(StatefulBeanContext ctx) throws SystemException {
        if (ctx.isTxSynchronized()) {
            return;
        }
        Transaction tx = this.tm.getTransaction();
        if (tx == null) {
            return;
        }
        if (tx.getStatus() == 1) {
            return;
        }
        SFSBSessionSynchronization synch = new SFSBSessionSynchronization(ctx);
        SessionSynchronization bean = (SessionSynchronization)ctx.getInstance();
        try {
            bean.afterBegin();
        }
        catch (EJBException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw new EJBException(e);
        }
        try {
            tx.registerSynchronization(synch);
        }
        catch (RollbackException ignore) {
            // empty catch block
        }
    }

    public Object invoke(Invocation invocation) throws Throwable {
        StatefulContainerInvocation ejb = (StatefulContainerInvocation)invocation;
        StatefulBeanContext target = (StatefulBeanContext)ejb.getBeanContext();
        if (target.getInstance() instanceof SessionSynchronization) {
            this.registerSessionSynchronization(target);
        }
        return ejb.invokeNext();
    }

    protected static class SFSBSessionSynchronization
    implements Synchronization {
        private StatefulBeanContext ctx;

        public SFSBSessionSynchronization(StatefulBeanContext ctx) {
            this.ctx = ctx;
        }

        public void beforeCompletion() {
            SessionSynchronization bean = (SessionSynchronization)this.ctx.getInstance();
            try {
                bean.beforeCompletion();
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void afterCompletion(int status) {
            this.ctx.setTxSynchronized(false);
            SessionSynchronization bean = (SessionSynchronization)this.ctx.getInstance();
            try {
                try {
                    if (status == 3) {
                        bean.afterCompletion(true);
                    }
                    bean.afterCompletion(false);
                }
                catch (RemoteException remoteException) {
                    Object var5_4 = null;
                    StatefulContainer container = (StatefulContainer)this.ctx.getContainer();
                    container.getCache().release(this.ctx);
                    return;
                }
                Object var5_3 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                StatefulContainer container = (StatefulContainer)this.ctx.getContainer();
                container.getCache().release(this.ctx);
                throw throwable;
            }
            StatefulContainer container = (StatefulContainer)this.ctx.getContainer();
            container.getCache().release(this.ctx);
        }
    }
}

