/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateful;

import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.ejb.EJBContext;
import javax.persistence.EntityManager;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import org.jboss.aop.metadata.SimpleMetaData;
import org.jboss.ejb3.Ejb3Registry;
import org.jboss.ejb3.ThreadLocalStack;
import org.jboss.ejb3.cache.Identifiable;
import org.jboss.ejb3.cache.StatefulCache;
import org.jboss.ejb3.interceptor.InterceptorInfo;
import org.jboss.ejb3.session.SessionBeanContext;
import org.jboss.ejb3.session.SessionContainer;
import org.jboss.ejb3.stateful.NestedStatefulBeanContext;
import org.jboss.ejb3.stateful.ProxiedStatefulBeanContext;
import org.jboss.ejb3.stateful.StatefulContainer;
import org.jboss.ejb3.stateful.StatefulSessionContextImpl;
import org.jboss.ejb3.tx.TxUtil;
import org.jboss.serial.io.MarshalledObject;
import org.jboss.tm.TxUtils;
import org.jboss.util.id.GUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatefulBeanContext
extends SessionBeanContext
implements Identifiable,
Serializable {
    private static final long serialVersionUID = -102470788178912606L;
    protected Object id;
    protected boolean txSynchronized = false;
    protected boolean inInvocation = false;
    protected MarshalledObject beanMO;
    protected ReentrantLock lock = new ReentrantLock();
    protected boolean discarded;
    public static ThreadLocalStack<StatefulBeanContext> propagatedContainedIn = new ThreadLocalStack();
    public static ThreadLocalStack<StatefulBeanContext> currentBean = new ThreadLocalStack();
    protected StatefulBeanContext containedIn;
    protected List<StatefulBeanContext> contains;
    protected HashMap<String, EntityManager> persistenceContexts;
    protected boolean removed;
    protected String containerClusterUid;
    protected String containerGuid;
    protected boolean isClustered = false;
    protected boolean replicationIsPassivation = true;
    protected transient boolean passivated = false;
    public volatile boolean markedForPassivation = false;
    public volatile boolean markedForReplication = false;
    private volatile boolean inUse = false;
    public long lastUsed = System.currentTimeMillis();

    protected StatefulBeanContext(SessionContainer container, MarshalledObject beanMO) {
        super(container);
        assert (beanMO != null) : "beanMO is null";
        this.containerClusterUid = Ejb3Registry.clusterUid(container);
        this.containerGuid = Ejb3Registry.guid(container);
        this.isClustered = container.isClustered();
        this.beanMO = beanMO;
    }

    protected StatefulBeanContext(SessionContainer container, Object bean) {
        super(container, bean);
        this.containerClusterUid = Ejb3Registry.clusterUid(container);
        this.containerGuid = Ejb3Registry.guid(container);
        this.isClustered = container.isClustered();
        this.id = new GUID();
    }

    public List<StatefulBeanContext> getContains() {
        if (this.bean == null) {
            this.extractBeanAndInterceptors();
        }
        return this.contains;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<StatefulBeanContext> getThreadSafeContains() {
        List<StatefulBeanContext> orig = this.getContains();
        ArrayList<StatefulBeanContext> copy = null;
        if (orig != null) {
            List<StatefulBeanContext> list2 = orig;
            synchronized (list2) {
                copy = new ArrayList<StatefulBeanContext>(orig);
            }
        }
        return copy;
    }

    @Override
    public EJBContext getEJBContext() {
        if (this.ejbContext == null) {
            this.ejbContext = new StatefulSessionContextImpl(this);
        }
        return this.ejbContext;
    }

    public EntityManager getExtendedPersistenceContext(String id) {
        EntityManager found = null;
        Map<String, EntityManager> extendedPCS = this.getExtendedPersistenceContexts();
        if (extendedPCS != null) {
            found = extendedPCS.get(id);
        }
        if (found != null) {
            return found;
        }
        if (this.containedIn != null) {
            found = this.containedIn.getExtendedPersistenceContext(id);
        }
        return found;
    }

    public void addExtendedPersistenceContext(String id, EntityManager pc) {
        Map<String, EntityManager> extendedPCS = this.getExtendedPersistenceContexts();
        if (extendedPCS == null) {
            this.persistenceContexts = new HashMap<String, EntityManager>();
            extendedPCS = this.persistenceContexts;
        }
        extendedPCS.put(id, pc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean scanForExtendedPersistenceContext(String id, StatefulBeanContext ignore) {
        Map<String, EntityManager> extendedPCS;
        if (this.equals(ignore)) {
            return false;
        }
        if (!this.removed && (extendedPCS = this.getExtendedPersistenceContexts()) != null && extendedPCS.containsKey(id)) {
            return true;
        }
        if (this.getContains() != null) {
            List<StatefulBeanContext> list2 = this.contains;
            synchronized (list2) {
                for (StatefulBeanContext contained : this.contains) {
                    if (contained.equals(ignore) || !contained.scanForExtendedPersistenceContext(id, ignore)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExtendedPersistenceContext(String id) {
        Map<String, EntityManager> extendedPCS = this.getExtendedPersistenceContexts();
        if (extendedPCS != null) {
            extendedPCS.remove(id);
        }
        if (this.getContains() != null) {
            List<StatefulBeanContext> list2 = this.contains;
            synchronized (list2) {
                for (StatefulBeanContext contained : this.contains) {
                    contained.removeExtendedPersistenceContext(id);
                }
            }
        }
    }

    public Map<String, EntityManager> getExtendedPersistenceContexts() {
        if (this.persistenceContexts == null && this.bean == null) {
            this.extractBeanAndInterceptors();
        }
        return this.persistenceContexts;
    }

    public StatefulBeanContext getContainedIn() {
        return this.containedIn;
    }

    public StatefulBeanContext getUltimateContainedIn() {
        StatefulBeanContext parent;
        StatefulBeanContext child = this;
        for (parent = this.containedIn; parent != null; parent = parent.getContainedIn()) {
            child = parent;
        }
        if (parent == null && this != child) {
            StatefulCache ultimateCache = ((StatefulContainer)child.getContainer()).getCache();
            child = ultimateCache.get(child.getId(), false);
        }
        return child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContains(StatefulBeanContext ctx) {
        if (this.getContains() == null) {
            this.contains = new ArrayList<StatefulBeanContext>();
        }
        List<StatefulBeanContext> list2 = this.contains;
        synchronized (list2) {
            this.contains.add(ctx);
            ctx.containedIn = this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContains(StatefulBeanContext ctx) {
        if (this.getContains() != null) {
            List<StatefulBeanContext> list2 = this.contains;
            synchronized (list2) {
                if (this.contains.remove(ctx)) {
                    ctx.containedIn = null;
                }
            }
            if (this.removed) {
                this.cleanExtendedPCs();
            }
            if (this.getCanRemoveFromCache()) {
                if (this.containedIn != null) {
                    this.containedIn.removeContains(this);
                }
                ((StatefulContainer)this.getContainer()).getCache().remove(this.getId());
            }
        }
    }

    public StatefulBeanContext pushContainedIn() {
        StatefulBeanContext thisPtr = this;
        if (propagatedContainedIn.getList() != null) {
            this.containedIn = propagatedContainedIn.get();
            NestedStatefulBeanContext nested = new NestedStatefulBeanContext(this.getContainer(), this.bean);
            nested.id = this.id;
            nested.container = this.getContainer();
            nested.containerClusterUid = this.containerClusterUid;
            nested.containerGuid = this.containerGuid;
            nested.isClustered = this.isClustered;
            nested.replicationIsPassivation = this.replicationIsPassivation;
            this.containedIn.addContains(nested);
            thisPtr = new ProxiedStatefulBeanContext(nested);
        }
        propagatedContainedIn.push(thisPtr);
        return thisPtr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getCanPassivate() {
        boolean canPassivate;
        boolean bl = canPassivate = this.removed || !this.inUse;
        if (canPassivate && this.contains != null) {
            List<StatefulBeanContext> list2 = this.contains;
            synchronized (list2) {
                for (StatefulBeanContext contained : this.contains) {
                    if (contained.getCanPassivate()) continue;
                    canPassivate = false;
                    break;
                }
            }
        }
        return canPassivate;
    }

    public void prePassivate() {
        List<StatefulBeanContext> children;
        if (!this.removed && !this.passivated) {
            this.getContainer().invokePrePassivate(this);
            this.passivated = true;
        }
        if ((children = this.getThreadSafeContains()) != null) {
            for (StatefulBeanContext contained : children) {
                contained.prePassivate();
            }
        }
    }

    public void postActivate() {
        List<StatefulBeanContext> children;
        if (!this.removed && this.passivated) {
            this.getContainer().invokePostActivate(this);
            this.passivated = false;
        }
        if ((children = this.getThreadSafeContains()) != null) {
            for (StatefulBeanContext contained : children) {
                contained.postActivate();
            }
        }
    }

    public void passivateAfterReplication() {
        List<StatefulBeanContext> children;
        if (!this.removed && !this.passivated) {
            this.getInstance();
            this.getContainer().invokePrePassivate(this);
            this.passivated = true;
        }
        if (this.contains != null && (children = this.getThreadSafeContains()) != null) {
            for (StatefulBeanContext contained : children) {
                contained.passivateAfterReplication();
            }
        }
    }

    public void activateAfterReplication() {
        List<StatefulBeanContext> children;
        if (!this.removed && this.passivated) {
            this.getInstance();
            this.getContainer().invokePostActivate(this);
            this.passivated = false;
        }
        if ((children = this.getThreadSafeContains()) != null) {
            for (StatefulBeanContext contained : children) {
                contained.activateAfterReplication();
            }
        }
    }

    public boolean getReplicationIsPassivation() {
        return this.replicationIsPassivation;
    }

    public void setReplicationIsPassivation(boolean replicationIsPassivation) {
        this.replicationIsPassivation = replicationIsPassivation;
    }

    public void preReplicate() {
        List<StatefulBeanContext> children;
        if (!this.removed && this.replicationIsPassivation && !this.passivated) {
            this.getContainer().invokePrePassivate(this);
            this.passivated = true;
        }
        if ((children = this.getThreadSafeContains()) != null) {
            for (StatefulBeanContext contained : children) {
                contained.preReplicate();
            }
        }
    }

    public void postReplicate() {
        List<StatefulBeanContext> children;
        if (!this.removed && this.passivated) {
            this.getContainer().invokePostActivate(this);
            this.passivated = false;
        }
        if ((children = this.getThreadSafeContains()) != null) {
            for (StatefulBeanContext contained : children) {
                contained.postReplicate();
            }
        }
    }

    public void popContainedIn() {
        propagatedContainedIn.pop();
    }

    public boolean isInUse() {
        return this.inUse;
    }

    public void setInUse(boolean inUse) {
        this.inUse = inUse;
    }

    public boolean isDiscarded() {
        return this.discarded;
    }

    public void setDiscarded(boolean discarded) {
        this.discarded = discarded;
    }

    public ReentrantLock getLock() {
        return this.lock;
    }

    public boolean isInInvocation() {
        return this.inInvocation;
    }

    public void setInInvocation(boolean inInvocation) {
        this.inInvocation = inInvocation;
    }

    @Override
    public Object getId() {
        return this.id;
    }

    public boolean isTxSynchronized() {
        return this.txSynchronized;
    }

    public void setTxSynchronized(boolean txSynchronized) {
        this.txSynchronized = txSynchronized;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    @Override
    public void remove() {
        RuntimeException exceptionThrown;
        block8: {
            block7: {
                if (this.removed) {
                    return;
                }
                this.removed = true;
                exceptionThrown = null;
                try {
                    this.cleanExtendedPCs();
                }
                catch (RuntimeException e) {
                    if (exceptionThrown != null) break block7;
                    exceptionThrown = e;
                }
            }
            if (this.containedIn != null && this.getCanRemoveFromCache()) {
                try {
                    this.containedIn.removeContains(this);
                }
                catch (RuntimeException e) {
                    if (exceptionThrown != null) break block8;
                    exceptionThrown = e;
                }
            }
        }
        this.bean = null;
        this.interceptorInstances = null;
        if (exceptionThrown != null) {
            throw new RuntimeException("exception thrown while removing SFSB", exceptionThrown);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getCanRemoveFromCache() {
        boolean canRemove = this.removed;
        if (canRemove && this.getContains() != null) {
            List<StatefulBeanContext> list2 = this.contains;
            synchronized (list2) {
                canRemove = this.contains.size() == 0;
            }
        }
        return canRemove;
    }

    private void cleanExtendedPCs() {
        try {
            Transaction tx = TxUtil.getTransactionManager().getTransaction();
            if (tx != null && TxUtils.isActive(tx)) {
                tx.registerSynchronization(new XPCCloseSynchronization(this));
            } else {
                this.closeExtendedPCs();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Error cleaning PersistenceContexts in SFSB removal", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeExtendedPCs() {
        Map<String, EntityManager> extendedPCS = this.getExtendedPersistenceContexts();
        if (extendedPCS != null) {
            RuntimeException exceptionThrown = null;
            ArrayList<String> closedXPCs = new ArrayList<String>();
            StatefulBeanContext topCtx = this.getUltimateContainedIn();
            for (Map.Entry<String, EntityManager> entry : extendedPCS.entrySet()) {
                String id = entry.getKey();
                EntityManager xpc = entry.getValue();
                boolean canClose = topCtx.scanForExtendedPersistenceContext(id, this);
                if (canClose && this.getContains() != null) {
                    List<StatefulBeanContext> list2 = this.contains;
                    synchronized (list2) {
                        for (StatefulBeanContext contained : this.contains) {
                            if (!contained.scanForExtendedPersistenceContext(id, null)) continue;
                            canClose = false;
                            break;
                        }
                    }
                }
                if (!canClose) continue;
                try {
                    xpc.close();
                    closedXPCs.add(id);
                }
                catch (RuntimeException e) {
                    exceptionThrown = e;
                }
            }
            for (String id : closedXPCs) {
                topCtx.removeExtendedPersistenceContext(id);
            }
            if (exceptionThrown != null) {
                throw new RuntimeException("Error closing PersistenceContexts in SFSB removal", exceptionThrown);
            }
        }
    }

    @Override
    public SessionContainer getContainer() {
        if (this.container == null) {
            this.container = (SessionContainer)Ejb3Registry.findContainer(this.containerGuid);
            if (this.isClustered && this.container == null) {
                this.container = (SessionContainer)Ejb3Registry.getClusterContainer(this.containerClusterUid);
            }
        }
        return (SessionContainer)this.container;
    }

    @Override
    public Object getInstance() {
        if (this.bean == null) {
            this.extractBeanAndInterceptors();
        }
        assert (this.bean != null) : "bean is null";
        return this.bean;
    }

    @Override
    public SimpleMetaData getMetaData() {
        return super.getMetaData();
    }

    @Override
    public Object[] getInterceptorInstances(InterceptorInfo[] interceptorInfos) {
        if (this.bean == null) {
            this.extractBeanAndInterceptors();
        }
        return super.getInterceptorInstances(interceptorInfos);
    }

    protected synchronized void extractBeanAndInterceptors() {
        if (this.beanMO == null) {
            return;
        }
        try {
            Object[] beanAndInterceptors = (Object[])this.beanMO.get();
            this.bean = beanAndInterceptors[0];
            this.persistenceContexts = (HashMap)beanAndInterceptors[1];
            ArrayList list2 = (ArrayList)beanAndInterceptors[2];
            this.interceptorInstances = new HashMap();
            if (list2 != null) {
                for (Object o : list2) {
                    this.interceptorInstances.put(o.getClass(), o);
                }
            }
            this.contains = (List)beanAndInterceptors[3];
            if (this.contains != null) {
                for (StatefulBeanContext contained : this.contains) {
                    contained.containedIn = this;
                }
            }
            this.beanMO = null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private Object writeReplace() throws ObjectStreamException {
        Serialized state = new Serialized();
        if (this.beanMO == null) {
            Object[] beanAndInterceptors = new Object[4];
            beanAndInterceptors[0] = this.bean;
            beanAndInterceptors[1] = this.persistenceContexts;
            if (this.interceptorInstances != null && this.interceptorInstances.size() > 0) {
                ArrayList list2 = new ArrayList();
                list2.addAll(this.interceptorInstances.values());
                beanAndInterceptors[2] = list2;
            }
            beanAndInterceptors[3] = this.contains;
            try {
                MarshalledObject mo = new MarshalledObject(beanAndInterceptors);
                state.beanMO = mo;
            }
            catch (IOException e) {
                throw new RuntimeException("Marshalling of bean " + this.bean + " failed", e);
            }
        } else {
            state.beanMO = this.beanMO;
        }
        state.containerClusterUid = this.containerClusterUid;
        state.containerGuid = this.containerGuid;
        state.isClustered = this.isClustered;
        state.id = this.id;
        state.lastUsed = this.lastUsed;
        state.metadata = this.metadata;
        state.removed = this.removed;
        state.replicationIsPassivation = this.replicationIsPassivation;
        return state;
    }

    @Override
    public Object getInvokedMethodKey() {
        return this.getId();
    }

    private static class XPCCloseSynchronization
    implements Synchronization {
        private StatefulBeanContext ctx;

        private XPCCloseSynchronization(StatefulBeanContext context) {
            this.ctx = context;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            this.ctx.closeExtendedPCs();
            this.ctx = null;
        }
    }

    private static class Serialized
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String containerClusterUid;
        private String containerGuid;
        private boolean isClustered = false;
        private Object id;
        private SimpleMetaData metadata;
        private long lastUsed;
        private MarshalledObject beanMO;
        private boolean removed;
        private boolean replicationIsPassivation;

        private Serialized() {
        }

        private Object readResolve() throws ObjectStreamException {
            StatefulContainer container = (StatefulContainer)Ejb3Registry.findContainer(this.containerGuid);
            if (this.isClustered && container == null) {
                container = (StatefulContainer)Ejb3Registry.getClusterContainer(this.containerClusterUid);
            }
            StatefulBeanContext context = new StatefulBeanContext((SessionContainer)container, this.beanMO);
            context.id = this.id;
            context.metadata = this.metadata;
            context.lastUsed = this.lastUsed;
            context.removed = this.removed;
            context.replicationIsPassivation = this.replicationIsPassivation;
            context.passivated = true;
            return context;
        }
    }
}

