/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.iiop.csiv2;

import java.io.UnsupportedEncodingException;
import java.security.Principal;
import org.jboss.iiop.csiv2.CSIv2Util;
import org.jboss.logging.Logger;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityAssociation;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.ORB;
import org.omg.CSI.AuthorizationElement;
import org.omg.CSI.EstablishContext;
import org.omg.CSI.GSS_NT_ExportedNameHelper;
import org.omg.CSI.IdentityToken;
import org.omg.CSI.SASContextBody;
import org.omg.CSI.SASContextBodyHelper;
import org.omg.CSIIOP.CompoundSecMech;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.CSIIOP.CompoundSecMechListHelper;
import org.omg.GSSUP.InitialContextToken;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.CodecPackage.TypeMismatch;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;

public class SASClientIdentityInterceptor
extends LocalObject
implements ClientRequestInterceptor {
    private static final Logger log = Logger.getLogger(SASClientIdentityInterceptor.class);
    private static final boolean traceEnabled = log.isTraceEnabled();
    private static final int sasContextId = 15;
    private static final IdentityToken absentIdentityToken = new IdentityToken();
    private static final AuthorizationElement[] noAuthorizationToken;
    private static final byte[] noAuthenticationToken;
    private Codec codec;
    private static final String serverUsername = "j2ee";
    private static final String serverPassword = "j2ee";

    public SASClientIdentityInterceptor(Codec codec) {
        this.codec = codec;
    }

    public String name() {
        return "SASClientIdentityInterceptor";
    }

    public void destroy() {
    }

    public void send_request(ClientRequestInfo ri) {
        try {
            CompoundSecMech secMech = CSIv2Util.getMatchingSecurityMech(ri, this.codec, (short)1088, (short)0);
            if (secMech == null) {
                return;
            }
            if (traceEnabled) {
                StringBuffer tmp = new StringBuffer();
                CSIv2Util.toString(secMech, tmp);
                log.trace(tmp);
            }
            IdentityToken identityToken = absentIdentityToken;
            byte[] encodedAuthenticationToken = noAuthenticationToken;
            if ((secMech.sas_context_mech.target_supports & 0x400) != 0) {
                Principal p = null;
                RunAsIdentity runAs = SecurityAssociation.peekRunAsIdentity();
                p = runAs != null ? runAs : SecurityAssociation.getPrincipal();
                if (p != null) {
                    String name = p.getName();
                    if (name.indexOf(64) < 0) {
                        name = name + "@default";
                    }
                    byte[] principalName = name.getBytes("UTF-8");
                    byte[] encodedName = CSIv2Util.encodeGssExportedName(principalName);
                    Any any = ORB.init().create_any();
                    byte[] encapsulatedEncodedName = null;
                    GSS_NT_ExportedNameHelper.insert((Any)any, (byte[])encodedName);
                    try {
                        encapsulatedEncodedName = this.codec.encode_value(any);
                    }
                    catch (InvalidTypeForEncoding e) {
                        throw new RuntimeException("Unexpected exception: " + (Object)((Object)e));
                    }
                    identityToken = new IdentityToken();
                    identityToken.principal_name(encapsulatedEncodedName);
                } else if ((secMech.sas_context_mech.supported_identity_types & 1) != 0) {
                    identityToken = new IdentityToken();
                    identityToken.anonymous(true);
                }
            }
            if ((secMech.as_context_mech.target_requires & 0x40) != 0) {
                byte[] encodedTargetName = secMech.as_context_mech.target_name;
                String name = "j2ee";
                if (name.indexOf(64) < 0) {
                    byte[] decodedTargetName = CSIv2Util.decodeGssExportedName(encodedTargetName);
                    String targetName = new String(decodedTargetName, "UTF-8");
                    name = name + "@" + targetName;
                }
                byte[] username = name.getBytes("UTF-8");
                byte[] password = "j2ee".getBytes("UTF-8");
                InitialContextToken authenticationToken = new InitialContextToken(username, password, encodedTargetName);
                encodedAuthenticationToken = CSIv2Util.encodeInitialContextToken(authenticationToken, this.codec);
            }
            if (identityToken != absentIdentityToken || encodedAuthenticationToken != noAuthenticationToken) {
                EstablishContext message = new EstablishContext(0L, noAuthorizationToken, identityToken, encodedAuthenticationToken);
                SASContextBody contextBody = new SASContextBody();
                contextBody.establish_msg(message);
                Any any = ORB.init().create_any();
                SASContextBodyHelper.insert((Any)any, (SASContextBody)contextBody);
                ServiceContext sc = new ServiceContext(15, this.codec.encode_value(any));
                ri.add_request_service_context(sc, true);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new MARSHAL("Unexpected exception: " + e);
        }
        catch (InvalidTypeForEncoding e) {
            throw new MARSHAL("Unexpected exception: " + (Object)((Object)e));
        }
    }

    public void send_poll(ClientRequestInfo ri) {
    }

    public void receive_reply(ClientRequestInfo ri) {
        try {
            ServiceContext sc = ri.get_reply_service_context(15);
            Any msg = this.codec.decode_value(sc.context_data, SASContextBodyHelper.type());
            SASContextBody contextBody = SASContextBodyHelper.extract((Any)msg);
            if (traceEnabled) {
                log.trace("receive_reply: got SAS reply, type " + contextBody.discriminator());
            }
            if (contextBody.discriminator() == 4) {
                log.warn("Unexpected ContextError in SAS reply");
                throw new NO_PERMISSION("Unexpected ContextError in SAS reply", 1245904897, CompletionStatus.COMPLETED_YES);
            }
        }
        catch (BAD_PARAM e) {
        }
        catch (FormatMismatch e) {
            throw new MARSHAL("Could not parse SAS reply: " + (Object)((Object)e), 0, CompletionStatus.COMPLETED_YES);
        }
        catch (TypeMismatch e) {
            throw new MARSHAL("Could not parse SAS reply: " + (Object)((Object)e), 0, CompletionStatus.COMPLETED_YES);
        }
    }

    public void receive_exception(ClientRequestInfo ri) {
        try {
            ServiceContext sc = ri.get_reply_service_context(15);
            Any msg = this.codec.decode_value(sc.context_data, SASContextBodyHelper.type());
            SASContextBody contextBody = SASContextBodyHelper.extract((Any)msg);
            if (traceEnabled) {
                log.trace("receive_exceptpion: got SAS reply, type " + contextBody.discriminator());
            }
        }
        catch (BAD_PARAM e) {
        }
        catch (FormatMismatch e) {
            throw new MARSHAL("Could not parse SAS reply: " + (Object)((Object)e), 1245904897, CompletionStatus.COMPLETED_MAYBE);
        }
        catch (TypeMismatch e) {
            throw new MARSHAL("Could not parse SAS reply: " + (Object)((Object)e), 1245904897, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public void receive_other(ClientRequestInfo ri) {
    }

    CompoundSecMech getSecurityMech(ClientRequestInfo ri) {
        CompoundSecMechList csmList = null;
        CompoundSecMech securityMech = null;
        try {
            TaggedComponent tc = ri.get_effective_component(33);
            Any any = this.codec.decode_value(tc.component_data, CompoundSecMechListHelper.type());
            csmList = CompoundSecMechListHelper.extract((Any)any);
            securityMech = csmList.mechanism_list[0];
        }
        catch (BAD_PARAM e) {
        }
        catch (TypeMismatch tm) {
        }
        catch (FormatMismatch tm) {
            // empty catch block
        }
        return securityMech;
    }

    static {
        absentIdentityToken.absent(true);
        noAuthorizationToken = new AuthorizationElement[0];
        noAuthenticationToken = new byte[0];
    }
}

