/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation.local;

import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.Invoker;
import org.jboss.invocation.InvokerInterceptor;
import org.jboss.invocation.local.LocalInvokerMBean;
import org.jboss.mx.util.JMXExceptionDecoder;
import org.jboss.proxy.TransactionInterceptor;
import org.jboss.system.Registry;
import org.jboss.system.ServiceMBeanSupport;

public class LocalInvoker
extends ServiceMBeanSupport
implements Invoker,
LocalInvokerMBean {
    private MBeanServerAction serverAction = new MBeanServerAction();

    protected void createService() throws Exception {
        InvokerInterceptor.setLocal(this);
        Registry.bind(this.serviceName, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startService() throws Exception {
        InitialContext ctx = new InitialContext();
        try {
            TransactionManager tm = (TransactionManager)ctx.lookup("java:/TransactionManager");
            TransactionInterceptor.setTransactionManager(tm);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ctx.close();
            throw throwable;
        }
        ctx.close();
        this.log.debug("Local invoker for JMX node started");
    }

    protected void destroyService() {
        Registry.unbind(this.serviceName);
    }

    public String getServerHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public Object invoke(Invocation invocation) throws Exception {
        Object object;
        ClassLoader oldCl = TCLAction.UTIL.getContextClassLoader();
        ObjectName mbean = (ObjectName)Registry.lookup((Integer)invocation.getObjectName());
        try {
            Object rtnValue;
            Object[] args = new Object[]{invocation};
            object = rtnValue = this.serverAction.invoke(mbean, "invoke", args, Invocation.INVOKE_SIGNATURE);
            Object var8_9 = null;
        }
        catch (Exception e) {
            try {
                e = (Exception)JMXExceptionDecoder.decode(e);
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Failed to invoke on mbean: " + mbean, e);
                }
                throw e;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                TCLAction.UTIL.setContextClassLoader(oldCl);
                throw throwable;
            }
        }
        TCLAction.UTIL.setContextClassLoader(oldCl);
        return object;
    }

    static interface TCLAction {
        public static final TCLAction NON_PRIVILEGED = new TCLAction(){

            public ClassLoader getContextClassLoader() {
                return Thread.currentThread().getContextClassLoader();
            }

            public ClassLoader getContextClassLoader(Thread thread) {
                return thread.getContextClassLoader();
            }

            public void setContextClassLoader(ClassLoader cl) {
                Thread.currentThread().setContextClassLoader(cl);
            }

            public void setContextClassLoader(Thread thread, ClassLoader cl) {
                thread.setContextClassLoader(cl);
            }
        };
        public static final TCLAction PRIVILEGED = new TCLAction(){
            private final PrivilegedAction getTCLPrivilegedAction = new PrivilegedAction(){

                public Object run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            };

            public ClassLoader getContextClassLoader() {
                return (ClassLoader)AccessController.doPrivileged(this.getTCLPrivilegedAction);
            }

            public ClassLoader getContextClassLoader(final Thread thread) {
                return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return thread.getContextClassLoader();
                    }
                });
            }

            public void setContextClassLoader(final ClassLoader cl) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Thread.currentThread().setContextClassLoader(cl);
                        return null;
                    }
                });
            }

            public void setContextClassLoader(final Thread thread, final ClassLoader cl) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        thread.setContextClassLoader(cl);
                        return null;
                    }
                });
            }
        };

        public ClassLoader getContextClassLoader();

        public ClassLoader getContextClassLoader(Thread var1);

        public void setContextClassLoader(ClassLoader var1);

        public void setContextClassLoader(Thread var1, ClassLoader var2);

        public static class UTIL {
            static TCLAction getTCLAction() {
                return System.getSecurityManager() == null ? NON_PRIVILEGED : PRIVILEGED;
            }

            static ClassLoader getContextClassLoader() {
                return UTIL.getTCLAction().getContextClassLoader();
            }

            static ClassLoader getContextClassLoader(Thread thread) {
                return UTIL.getTCLAction().getContextClassLoader(thread);
            }

            static void setContextClassLoader(ClassLoader cl) {
                UTIL.getTCLAction().setContextClassLoader(cl);
            }

            static void setContextClassLoader(Thread thread, ClassLoader cl) {
                UTIL.getTCLAction().setContextClassLoader(thread, cl);
            }
        }
    }

    class MBeanServerAction
    implements PrivilegedExceptionAction {
        private ObjectName target;
        String method;
        Object[] args;
        String[] sig;

        MBeanServerAction() {
        }

        MBeanServerAction(ObjectName target, String method, Object[] args, String[] sig) {
            this.target = target;
            this.method = method;
            this.args = args;
            this.sig = sig;
        }

        public Object run() throws Exception {
            Object rtnValue = LocalInvoker.this.server.invoke(this.target, this.method, this.args, this.sig);
            return rtnValue;
        }

        Object invoke(ObjectName target, String method, Object[] args, String[] sig) throws Exception {
            SecurityManager sm = System.getSecurityManager();
            Object rtnValue = null;
            if (sm == null) {
                rtnValue = LocalInvoker.this.server.invoke(target, method, args, sig);
            } else {
                try {
                    MBeanServerAction action = new MBeanServerAction(target, method, args, sig);
                    rtnValue = AccessController.doPrivileged(action);
                }
                catch (PrivilegedActionException e) {
                    Exception ex = e.getException();
                    throw ex;
                }
            }
            return rtnValue;
        }
    }
}

