/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.wireformat;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.jboss.jms.wireformat.CallbackSupport;
import org.jboss.jms.wireformat.ClientDelivery;
import org.jboss.jms.wireformat.ConnectionFactoryUpdate;
import org.jboss.jms.wireformat.PacketSupport;
import org.jboss.remoting.InvocationResponse;
import org.jboss.remoting.callback.Callback;

public class PolledCallbacksDelivery
extends PacketSupport {
    private List callbacks;
    private String sessionID;

    public PolledCallbacksDelivery() {
    }

    public PolledCallbacksDelivery(List callbacks, String sessionID) {
        super(4);
        this.callbacks = callbacks;
        this.sessionID = sessionID;
    }

    public void read(DataInputStream is) throws Exception {
        this.sessionID = is.readUTF();
        int len = is.readInt();
        this.callbacks = new ArrayList(len);
        for (int i = 0; i < len; ++i) {
            CallbackSupport cs;
            int id = is.readInt();
            switch (id) {
                case 2: {
                    cs = new ClientDelivery();
                    break;
                }
                case 3: {
                    cs = new ConnectionFactoryUpdate();
                    break;
                }
                default: {
                    throw new IllegalStateException("Can't deal with methodId=" + id);
                }
            }
            cs.read(is);
            Callback cb = new Callback(cs);
            this.callbacks.add(cb);
        }
    }

    public void write(DataOutputStream os) throws Exception {
        super.write(os);
        os.writeUTF(this.sessionID);
        os.writeInt(this.callbacks.size());
        for (Callback cb : this.callbacks) {
            CallbackSupport cs = (CallbackSupport)cb.getParameter();
            cs.write(os);
        }
        os.flush();
    }

    public Object getPayload() {
        return new InvocationResponse(this.sessionID, this.callbacks, false, null);
    }
}

