/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.wireformat;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.jboss.jms.delegate.Cancel;
import org.jboss.jms.delegate.DefaultCancel;
import org.jboss.jms.delegate.SessionEndpoint;
import org.jboss.jms.wireformat.Dispatcher;
import org.jboss.jms.wireformat.RequestSupport;
import org.jboss.jms.wireformat.ResponseSupport;

public class SessionCancelDeliveryRequest
extends RequestSupport {
    private Cancel cancel;

    public SessionCancelDeliveryRequest() {
    }

    public SessionCancelDeliveryRequest(String objectId, byte version, Cancel cancel) {
        super(objectId, 308, version);
        this.cancel = cancel;
    }

    public void read(DataInputStream is) throws Exception {
        super.read(is);
        long deliveryId = is.readLong();
        int deliveryCount = is.readInt();
        boolean expired = is.readBoolean();
        boolean reachedMax = is.readBoolean();
        this.cancel = new DefaultCancel(deliveryId, deliveryCount, expired, reachedMax);
    }

    public ResponseSupport serverInvoke() throws Exception {
        SessionEndpoint endpoint = (SessionEndpoint)Dispatcher.instance.getTarget(this.objectId);
        if (endpoint == null) {
            throw new IllegalStateException("Cannot find object in dispatcher with id " + this.objectId);
        }
        endpoint.cancelDelivery(this.cancel);
        return null;
    }

    public void write(DataOutputStream os) throws Exception {
        super.write(os);
        os.writeLong(this.cancel.getDeliveryId());
        os.writeInt(this.cancel.getDeliveryCount());
        os.writeBoolean(this.cancel.isExpired());
        os.writeBoolean(this.cancel.isReachedMaxDeliveryAttempts());
        os.flush();
    }
}

