/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.annotations;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractPropertyMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.kernel.plugins.annotations.AbstractAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.Annotation2ValueMetaDataAdapter;
import org.jboss.kernel.plugins.annotations.PropertyAware;
import org.jboss.kernel.spi.dependency.KernelControllerContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertyAnnotationPlugin<C extends Annotation>
extends AbstractAnnotationPlugin<PropertyInfo, C>
implements PropertyAware,
Annotation2ValueMetaDataAdapter<C> {
    protected PropertyAnnotationPlugin(Class<C> annotation) {
        super(annotation);
    }

    @Override
    protected boolean isElementTypeSupported(ElementType type) {
        return ElementType.METHOD == type || ElementType.PARAMETER == type;
    }

    @Override
    protected boolean isMetaDataAlreadyPresent(PropertyInfo info, C annotation, BeanMetaData beanMetaData) {
        Set<PropertyMetaData> properties = beanMetaData.getProperties();
        if (properties != null && !properties.isEmpty()) {
            for (PropertyMetaData pmd : properties) {
                if (!pmd.getName().equals(info.getName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected List<? extends MetaDataVisitorNode> internalApplyAnnotation(PropertyInfo info, C annotation, KernelControllerContext context) {
        Set<PropertyMetaData> properties = this.getProperties(context);
        PropertyMetaData property = this.getPropertyMetaData(info, annotation, context);
        properties.add(property);
        return Collections.singletonList(property);
    }

    protected PropertyMetaData getPropertyMetaData(PropertyInfo info, C annotation, KernelControllerContext context) {
        return this.getPropertyMetaData(info, annotation, context.getBeanMetaData());
    }

    protected PropertyMetaData getPropertyMetaData(PropertyInfo info, C annotation, BeanMetaData beanMetaData) {
        return this.getPropertyMetaData(info, annotation);
    }

    protected PropertyMetaData getPropertyMetaData(PropertyInfo info, C annotation) {
        ValueMetaData value = this.createValueMetaData(annotation);
        return new AbstractPropertyMetaData(info.getName(), value);
    }

    protected Set<PropertyMetaData> getProperties(KernelControllerContext context) {
        BeanMetaData beanMetaData = context.getBeanMetaData();
        Set<PropertyMetaData> properties = beanMetaData.getProperties();
        if (properties == null) {
            properties = new HashSet<PropertyMetaData>();
            AbstractBeanMetaData bean = (AbstractBeanMetaData)beanMetaData;
            bean.setProperties(properties);
        }
        return properties;
    }
}

