/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.deployment;

import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.deployment.AbstractKernelDeployer;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.logging.Logger;

public class BasicKernelDeployer
extends AbstractKernelDeployer {
    private static final Logger log = Logger.getLogger(BasicKernelDeployer.class);
    protected List<KernelDeployment> deployments = new CopyOnWriteArrayList<KernelDeployment>();

    public BasicKernelDeployer(Kernel kernel) {
        this(kernel, null);
    }

    public BasicKernelDeployer(Kernel kernel, ControllerMode mode) {
        super(kernel, mode);
    }

    public void deploy(KernelDeployment deployment) throws Throwable {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace("Deploying " + deployment);
        }
        super.deploy(deployment);
        this.deployments.add(deployment);
        if (trace) {
            log.trace("Deployed " + deployment);
        }
    }

    public void undeploy(KernelDeployment deployment) {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace("Undeploying " + deployment);
        }
        this.deployments.remove(deployment);
        super.undeploy(deployment);
        if (trace) {
            log.trace("Undeployed " + deployment);
        }
    }

    public void shutdown() {
        ListIterator<KernelDeployment> iterator = this.deployments.listIterator(this.deployments.size());
        while (iterator.hasPrevious()) {
            KernelDeployment deployment = iterator.previous();
            this.undeploy(deployment);
        }
    }
}

