/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.metadata.basic;

import java.util.ArrayList;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ScopeInfo;
import org.jboss.kernel.plugins.metadata.AbstractKernelMetaDataRepository;
import org.jboss.metadata.plugins.context.AbstractMetaDataContext;
import org.jboss.metadata.plugins.loader.memory.MemoryMetaDataLoader;
import org.jboss.metadata.plugins.repository.basic.BasicMetaDataRepository;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.repository.MutableMetaDataRepository;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.scope.Scope;
import org.jboss.metadata.spi.scope.ScopeKey;

public class BasicKernelMetaDataRepository
extends AbstractKernelMetaDataRepository {
    public BasicKernelMetaDataRepository() {
        super(new BasicMetaDataRepository());
    }

    public MetaData getMetaData(ControllerContext context) {
        ScopeKey scope;
        MutableMetaDataRepository repository = this.getMetaDataRepository();
        MetaData metaData = repository.getMetaData(scope = context.getScopeInfo().getScope());
        if (metaData == null) {
            this.initMetaDataRetrieval(context);
            metaData = repository.getMetaData(scope);
            if (metaData == null) {
                throw new IllegalStateException("Error initialising metadata state: " + scope);
            }
        }
        return metaData;
    }

    public void addMetaData(ControllerContext context) {
        MutableMetaDataRepository repository = this.getMetaDataRepository();
        ScopeInfo scopeInfo = context.getScopeInfo();
        scopeInfo.addMetaData(repository, context);
    }

    public void removeMetaData(ControllerContext context) {
        MutableMetaDataRepository repository = this.getMetaDataRepository();
        ScopeInfo scopeInfo = context.getScopeInfo();
        scopeInfo.removeMetaData(repository, context);
    }

    public ScopeKey getFullScope(ControllerContext context) {
        return context.getScopeInfo().getScope();
    }

    public ScopeKey getMutableScope(ControllerContext context) {
        return context.getScopeInfo().getMutableScope();
    }

    protected MetaDataRetrieval initMetaDataRetrieval(ControllerContext context) {
        MutableMetaDataRepository repository = this.getMetaDataRepository();
        ScopeInfo scopeInfo = context.getScopeInfo();
        ScopeKey scopeKey = scopeInfo.getScope();
        ArrayList<MetaDataRetrieval> retrievals = new ArrayList<MetaDataRetrieval>();
        for (Scope scope : scopeKey.getScopes()) {
            ScopeKey thisScope = new ScopeKey(scope);
            MetaDataRetrieval retrieval = repository.getMetaDataRetrieval(thisScope);
            if (retrieval == null && (retrieval = scopeInfo.initMetaDataRetrieval(repository, context, scope)) == null) {
                retrieval = new MemoryMetaDataLoader(thisScope);
                repository.addMetaDataRetrieval(retrieval);
            }
            retrievals.add(0, retrieval);
        }
        AbstractMetaDataContext metaDataContext = new AbstractMetaDataContext(null, retrievals);
        repository.addMetaDataRetrieval(metaDataContext);
        return metaDataContext;
    }
}

