/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging;

import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.log4j.LogManager;
import org.apache.log4j.MDC;
import org.apache.log4j.net.SocketNode;
import org.apache.log4j.spi.LoggerRepository;
import org.jboss.logging.Log4jSocketServerMBean;
import org.jboss.logging.Logger;
import org.jboss.system.MissingAttributeException;
import org.jboss.system.ServiceMBeanSupport;

public class Log4jSocketServer
extends ServiceMBeanSupport
implements Log4jSocketServerMBean {
    protected int port = -1;
    protected int backlog = 50;
    protected InetAddress bindAddress;
    protected boolean listenerEnabled = true;
    protected SocketListenerThread listenerThread;
    protected ServerSocket serverSocket;
    protected LoggerRepositoryFactory loggerRepositoryFactory;

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBindAddress(InetAddress addr) {
        this.bindAddress = addr;
    }

    public InetAddress getBindAddress() {
        return this.bindAddress;
    }

    public void setListenerEnabled(boolean enabled) {
        this.listenerEnabled = enabled;
    }

    public boolean setListenerEnabled() {
        return this.listenerEnabled;
    }

    public void setLoggerRepositoryFactoryType(Class type) throws InstantiationException, IllegalAccessException, ClassCastException {
        this.loggerRepositoryFactory = (LoggerRepositoryFactory)type.newInstance();
    }

    public Class getLoggerRepositoryFactoryType() {
        if (this.loggerRepositoryFactory == null) {
            return null;
        }
        return this.loggerRepositoryFactory.getClass();
    }

    public LoggerRepository getLoggerRepository(InetAddress addr) {
        return this.loggerRepositoryFactory.create(addr);
    }

    protected void createService() throws Exception {
        this.listenerThread = new SocketListenerThread(false);
        this.listenerThread.setDaemon(true);
        this.listenerThread.start();
        this.log.debug("Socket listener thread started");
        if (this.loggerRepositoryFactory == null) {
            this.log.debug("Using default logger repository factory");
            this.loggerRepositoryFactory = new DefaultLoggerRepositoryFactory();
        }
    }

    protected void startService() throws Exception {
        if (this.port == -1) {
            throw new MissingAttributeException("Port");
        }
        this.serverSocket = this.bindAddress == null ? new ServerSocket(this.port, this.backlog) : new ServerSocket(this.port, this.backlog, this.bindAddress);
        this.log.info("Listening on " + this.serverSocket);
        this.listenerThread.setEnabled(this.listenerEnabled);
    }

    protected void stopService() throws Exception {
        this.listenerThread.setEnabled(false);
    }

    protected void destroyService() throws Exception {
        this.listenerThread.shutdown();
        this.listenerThread = null;
        this.serverSocket = null;
    }

    public static class DefaultLoggerRepositoryFactory
    implements LoggerRepositoryFactory {
        private LoggerRepository repo;

        public LoggerRepository create(InetAddress addr) {
            if (this.repo == null) {
                this.repo = LogManager.getLoggerRepository();
            }
            return this.repo;
        }
    }

    public static interface LoggerRepositoryFactory {
        public LoggerRepository create(InetAddress var1);
    }

    static class SocketThread
    extends Thread {
        String host;

        SocketThread(Runnable target, String host) {
            super(target, host + " LoggingEvent Thread");
            this.host = host;
        }

        public void run() {
            MDC.put((String)"host", (Object)this.host);
            super.run();
        }
    }

    protected class SocketListenerThread
    extends Thread {
        protected Logger log;
        protected boolean enabled;
        protected boolean shuttingDown;
        protected Object lock;

        public SocketListenerThread(boolean enabled) {
            super("SocketListenerThread");
            this.log = Logger.getLogger(SocketListenerThread.class);
            this.lock = new Object();
            this.enabled = enabled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
            this.log.debug("Notified that enabled: " + enabled);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.enabled = false;
            this.shuttingDown = true;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
            this.log.debug("Notified to shutdown");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.shuttingDown) {
                if (!this.enabled) {
                    try {
                        this.log.debug("Disabled, waiting for notification");
                        Object object = this.lock;
                        synchronized (object) {
                            this.lock.wait();
                        }
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                }
                try {
                    this.doRun();
                }
                catch (Throwable e) {
                    this.log.error("Exception caught from main loop; ignoring", e);
                }
            }
        }

        protected void doRun() throws Exception {
            while (this.enabled) {
                Socket socket = Log4jSocketServer.this.serverSocket.accept();
                InetAddress addr = socket.getInetAddress();
                this.log.debug("Connected to client at " + addr);
                LoggerRepository repo = Log4jSocketServer.this.getLoggerRepository(addr);
                this.log.debug("Using repository: " + repo);
                this.log.debug("Starting new socket node");
                SocketNode node = new SocketNode(socket, repo);
                String clientHost = addr.getHostName();
                SocketThread thread = new SocketThread((Runnable)node, clientHost);
                thread.start();
                this.log.debug("Socket node started");
            }
        }
    }
}

