/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.managed.plugins.advice;

import java.util.Iterator;
import org.jboss.managed.plugins.advice.WrapperAdvice;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrapperIterator<T>
implements Iterator<T> {
    private Iterator<T> delegate;
    private Class<T> interfaceClass;

    public WrapperIterator(Iterator<T> delegate, Class<T> interfaceClass) {
        if (delegate == null) {
            throw new IllegalArgumentException("Null delegate");
        }
        if (interfaceClass == null) {
            throw new IllegalArgumentException("Null interface class");
        }
        this.delegate = delegate;
        this.interfaceClass = interfaceClass;
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    @Override
    public T next() {
        T next = this.delegate.next();
        return WrapperAdvice.createProxy(next, this.interfaceClass);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

